package ru.yandex.partner.core.entity.block.multistate;

import java.util.List;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.block.model.ContentBlock;
import ru.yandex.partner.core.multistate.Multistate;
import ru.yandex.partner.core.multistate.block.BlockStateFlag;
import ru.yandex.partner.libs.i18n.GettextMsg;
import ru.yandex.partner.libs.multistate.action.ActionEntry;
import ru.yandex.partner.libs.multistate.action.ActionNameHolder;
import ru.yandex.partner.libs.multistate.graph.AbstractMultistateGraph;

@Component
@ParametersAreNonnullByDefault
public class ContentBlockMultistateGraph extends AbstractMultistateGraph<ContentBlock, BlockStateFlag> {


    @Override
    protected Map<ActionNameHolder, ActionEntry<ContentBlock, BlockStateFlag>> createGraph() {
        return Map.of();
    }

    @Override
    protected Multistate<BlockStateFlag> getMultistateForValue(Long multistateValue) {
        return new Multistate<BlockStateFlag>() {
            @Override
            public boolean hasFlag(BlockStateFlag flag) {
                return false;
            }

            @Override
            public boolean test(BlockStateFlag flag) {
                return false;
            }

            @Override
            public void setFlags(Map<BlockStateFlag, Boolean> values) {

            }

            @Override
            public List<BlockStateFlag> getEnabledFlags() {
                return null;
            }

            @Override
            public long toMultistateValue() {
                return 0;
            }

            @Override
            public List<GettextMsg> getNameMessages() {
                return null;
            }

            @Override
            public Multistate<BlockStateFlag> copy() {
                return null;
            }
        };
    }

    @Override
    public Multistate<BlockStateFlag> getMultistateFromModel(ContentBlock model) {
        return null;
    }

    @Override
    public Class<ContentBlock> getModelClass() {
        return ContentBlock.class;
    }

    @Override
    public Multistate<BlockStateFlag> convertMultistate(List<BlockStateFlag> enabledFlags) {
        return null;
    }
}
