package ru.yandex.partner.core.entity.block.repository;

import java.util.List;

import NPartner.Page;
import org.jetbrains.annotations.NotNull;

import ru.yandex.partner.core.bs.BkFiller;
import ru.yandex.partner.core.entity.block.container.BlockBkDictContainer;
import ru.yandex.partner.core.entity.block.model.BaseBlock;

public interface BlockBkFiller<B extends BaseBlock> extends
        BkFiller<B, Page.TPartnerPage.TBlock.Builder, BlockBkDictContainer> {
    /**
     * Частичная сортировка саппортов, из-за логики условного перезатирания.
     * Порядок элементов в энаме определяет порядок вызовов саппортов
     */
    enum Order {
        EX_DIRECT_FIELDS,
        SITE_VERSION,
        RTB_FIELDS_AND_SHOW_VIDEO,
        // после RtbFieldsAndShowVideo, т.к. условно перезатирает его значение VIDEO_MOTION
        DESIGN_TEMPLATES_AND_SITE_VERSION,
        // после ExDirectFields, лимит выставленный им приоритетнее
        // после siteVersion, иначе затираются adtypeset
        RTB_FIELDS_AND_DESIGN_TEMPLATES
    }

    @Override
    default int order() {
        return Integer.MAX_VALUE;
    }

    @Override
    default void fillContainer(BlockBkDictContainer container, @NotNull List<? extends B> models) {

    }
}
