package ru.yandex.partner.core.entity.block.repository;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.jooq.Table;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import ru.yandex.partner.core.configuration.DslContextProviderStub;
import ru.yandex.partner.core.entity.block.container.BlockContainer;
import ru.yandex.partner.core.entity.block.model.BaseBlock;
import ru.yandex.partner.core.entity.block.repository.filter.BlockFilterFactory;
import ru.yandex.partner.core.entity.block.repository.type.BlockRepositoryTypeSupportFacade;
import ru.yandex.partner.core.multitype.repository.PartnerModifyRepository;
import ru.yandex.partner.core.service.dbutil.DbValuesGenerator;

import static ru.yandex.partner.dbschema.partner.Tables.CONTEXT_ON_SITE_RTB;

@Repository
@ParametersAreNonnullByDefault
public class BlockModifyRepository extends PartnerModifyRepository<BaseBlock, BaseBlock, BlockContainer,
        BlockContainer> {
    // TODO: Заменить директовский dbValuesGenerator на генератор на основе *_block_seq
    private final DbValuesGenerator dbValuesGenerator;

    @Autowired
    public BlockModifyRepository(DSLContext dslContext, BlockRepositoryTypeSupportFacade typeSupportFacade,
                                 BlockTypedRepository typedRepository,
                                 DbValuesGenerator dbValuesGenerator) {
        super(
                new DslContextProviderStub(dslContext),
                typeSupportFacade,
                typedRepository,
                BlockFilterFactory.blockCompositeId()
        );
        this.dbValuesGenerator = dbValuesGenerator;
    }

    @Override
    protected void generateIds(BlockContainer addContainer, List<? extends BaseBlock> models) {
        // TODO: Исправить на правильную реализацию с использованием *_block_seq
//        Iterator<Long> blockIds = longValues(
//                dbValuesGenerator.generateValues(
//                        USERS,
//                        USERS.ID,
//                        mapList(models, ModelWithId::getId))
//        ).iterator();
//        models.forEach(user -> user.setId(blockIds.next()));
    }

    @Override
    protected Table<?> getLockTable() {
        return CONTEXT_ON_SITE_RTB;
    }
}
