package ru.yandex.partner.core.entity.block.repository.filter;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

import ru.yandex.direct.multitype.repository.filter.ConditionFilter;
import ru.yandex.partner.core.entity.PageBlockIds;
import ru.yandex.partner.core.entity.block.model.BaseBlock;
import ru.yandex.partner.core.entity.utils.ConditionUtils;
import ru.yandex.partner.core.multitype.repository.relation.Id;

import static ru.yandex.direct.multitype.repository.filter.ConditionFilterFactory.whereInFilter;
import static ru.yandex.partner.core.block.BlockUniqueIdConverter.blockIdFromUniqueId;
import static ru.yandex.partner.core.block.BlockUniqueIdConverter.pageIdFromUniqueId;
import static ru.yandex.partner.dbschema.partner.Tables.CONTEXT_ON_SITE_RTB;

public class BlockFilterFactory {
    private BlockFilterFactory() {
    }

    public static ConditionFilter blockPageIdFilter(Collection<Long> pageIds) {
        return whereInFilter(CONTEXT_ON_SITE_RTB.CAMPAIGN_ID, pageIds);
    }

    public static ConditionFilter blockCompositeIdsFilter(Collection<Long> blockIds) {
        return new BlockUniqueIdFilter(blockIds);
    }

    public static Id<BaseBlock> blockCompositeId() {
        return modelIds -> {
            List<PageBlockIds> list = modelIds.stream()
                    .map(id -> new PageBlockIds(pageIdFromUniqueId(id), blockIdFromUniqueId(id)))
                    .collect(Collectors.toList());

            return ConditionUtils.toPageBlockCondition(
                    list,
                    CONTEXT_ON_SITE_RTB.CAMPAIGN_ID,
                    CONTEXT_ON_SITE_RTB.ID
            );
        };
    }
}
