package ru.yandex.partner.core.entity.block.repository.filter;

import java.util.Collection;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.Condition;

import ru.yandex.direct.multitype.repository.filter.ConditionFilter;

@ParametersAreNonnullByDefault
public class BlockUniqueIdFilter extends ConditionFilter {
    private final Collection<Long> ids;

    public BlockUniqueIdFilter(Collection<Long> ids) {
        this.ids = ids;
    }

    public Collection<Long> ids() {
        return ids;
    }

    @Override
    public Condition getCondition() {
        return BlockFilterFactory.blockCompositeId().in(ids);
    }

    @Override
    public boolean isEmpty() {
        return ids.isEmpty();
    }
}
