package ru.yandex.partner.core.entity.block.repository.type;

import java.util.Collection;
import java.util.HashSet;

import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.PostConstruct;

import org.jooq.DSLContext;

import ru.yandex.direct.jooqmapperhelper.InsertHelperAggregator;
import ru.yandex.direct.jooqmapperhelper.UpdateHelperAggregator;
import ru.yandex.direct.model.AppliedChanges;
import ru.yandex.partner.core.entity.block.model.BaseBlock;
import ru.yandex.partner.core.holder.ModelPropertiesHolder;
import ru.yandex.partner.core.multitype.repository.CommonTypeSupportModifyStrategy;
import ru.yandex.partner.core.multitype.repository.TypeSupportModifyStrategy;
import ru.yandex.partner.dbschema.partner.tables.ContextOnSiteRtb;
import ru.yandex.partner.dbschema.partner.tables.records.ContextOnSiteRtbRecord;

import static ru.yandex.partner.core.holder.ModelPropertiesHolder.fromModelProperties;

@ParametersAreNonnullByDefault
public abstract class AbstractBlockRepositoryTypeSupportWithMapper<B extends BaseBlock>
        extends AbstractBlockRepositoryTypeSupport<B> implements BlockRepositoryTypeSupportWithMapper<B> {
    private final TypeSupportModifyStrategy<B, ContextOnSiteRtbRecord> modifyStrategy;
    private ModelPropertiesHolder defaultEditableProps;

    public AbstractBlockRepositoryTypeSupportWithMapper(DSLContext dslContext) {
        this(dslContext,
                new CommonTypeSupportModifyStrategy<>(
                        ContextOnSiteRtb.CONTEXT_ON_SITE_RTB,
                        ContextOnSiteRtb.CONTEXT_ON_SITE_RTB.UNIQUE_ID)
        );
    }

    public AbstractBlockRepositoryTypeSupportWithMapper(DSLContext dslContext, TypeSupportModifyStrategy<B,
            ContextOnSiteRtbRecord> modifyStrategy) {
        super(dslContext);
        this.modifyStrategy = modifyStrategy;
    }

    @PostConstruct
    public void init() {
        this.defaultEditableProps = fromModelProperties(new HashSet<>(getJooqMapper().getWritableModelProperties()));
    }

    @Override
    public ModelPropertiesHolder getEditableModelProperties(B model) {
        return this.defaultEditableProps;
    }

    @Override
    public void pushToInsert(InsertHelperAggregator insertHelperAggregator, B block) {
        modifyStrategy.pushToInsert(getJooqMapper(), insertHelperAggregator, block);
    }

    @Override
    public void processUpdate(UpdateHelperAggregator updateHelperAggregator,
                              Collection<AppliedChanges<B>> appliedChanges) {
        modifyStrategy.processUpdate(getJooqMapper(), updateHelperAggregator, appliedChanges);
    }
}
