package ru.yandex.partner.core.entity.block.service;

import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

import ru.yandex.partner.core.action.result.ActionsResult;
import ru.yandex.partner.core.entity.IncomingFields;
import ru.yandex.partner.core.entity.block.container.BlockContainer;
import ru.yandex.partner.core.entity.block.model.BaseBlock;
import ru.yandex.partner.core.entity.page.model.BasePage;
import ru.yandex.partner.core.entity.page.model.PageWithOwner;
import ru.yandex.partner.core.filter.CoreFilterNode;
import ru.yandex.partner.libs.annotation.PartnerTransactional;

public interface BlockAddService<BB extends BaseBlock> {

    @PartnerTransactional
    <B extends BB, P extends PageWithOwner> ActionsResult<?> addModels(
            Class<B> modelClass,
            List<B> models,
            Class<P> pageClass,
            IncomingFields incomingFields,
            OperationMode mode,
            Consumer<BlockContainer> configurer
    );

    <B extends BB, P extends BasePage> Map<Long, P> getReachablePages(
            Class<B> blockClass,
            List<B> blocks,
            Class<P> pageClass,
            CoreFilterNode<? super P> reachablePagesFilter);
}
