package ru.yandex.partner.core.entity.block.service;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.model.Model;
import ru.yandex.direct.model.ModelProperty;
import ru.yandex.partner.core.entity.ModelQueryService;
import ru.yandex.partner.core.entity.Query;
import ru.yandex.partner.core.entity.block.filter.BlockFilters;
import ru.yandex.partner.core.entity.block.model.BaseBlock;
import ru.yandex.partner.core.entity.block.repository.BlockTypedRepository;
import ru.yandex.partner.core.entity.tasks.doaction.DoActionFilterEnum;
import ru.yandex.partner.core.filter.meta.MetaFilter;

import static ru.yandex.direct.multitype.typesupport.TypeFilteringUtils.filterModelsOfClass;

@Service
@ParametersAreNonnullByDefault
public class BlockService implements ModelQueryService<BaseBlock> {
    private final BlockTypedRepository blockTypedRepository;

    @Autowired
    public BlockService(BlockTypedRepository blockTypedRepository) {
        this.blockTypedRepository = blockTypedRepository;
    }

    @Override
    public <S extends BaseBlock> long count(Query<S> opts) {
        return blockTypedRepository.getEntityCountByCondition(opts.getFilter(), opts.getClazz());
    }

    @Override
    public ModelProperty<? extends Model, Long> getIdModelProperty() {
        return BaseBlock.ID;
    }

    @Override
    public <B extends BaseBlock> List<B> findAll(Query<B> opts) {
        return filterModelsOfClass(
                blockTypedRepository.getAll(opts),
                opts.getClazz()
        );
    }

    @Override
    public Class<BaseBlock> getBaseClass() {
        return BaseBlock.class;
    }

    @Override
    public <S extends BaseBlock>
    MetaFilter<? super S, ?> getMetaFilterForDoAction(DoActionFilterEnum doActionFilterEnum) {

        return switch (doActionFilterEnum) {
            case PAGE_ID -> BlockFilters.PAGE_ID;
            case MULTISTATE -> BlockFilters.MULTISTATE;
        };
    }

}
