package ru.yandex.partner.core.entity.block.service;

import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.partner.core.entity.block.model.BaseBlock;

@ParametersAreNonnullByDefault
public class BlockUpdateOperationConstants {

    /**
     * Если саппорт навешен на класс, который есть в этом белом списке или на класс, который наследуются от класса,
     * который есть в этом белом списке - то такой саппорт будет вызываться всегда, независимо от изменившихся данных.
     */
    public static final Set<Class<? extends BaseBlock>> BLOCK_TYPE_SUPPORT_CLASS_WHITE_LIST = Set.of(
            BaseBlock.class
    );

    private BlockUpdateOperationConstants() {

    }
}
