package ru.yandex.partner.core.entity.block.service;

import java.util.Collection;
import java.util.List;
import java.util.function.Function;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.springframework.stereotype.Component;

import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.operation.Applicability;
import ru.yandex.partner.core.entity.IncomingFields;
import ru.yandex.partner.core.entity.block.container.BlockContainer;
import ru.yandex.partner.core.entity.block.model.BaseBlock;
import ru.yandex.partner.core.entity.block.repository.BlockModifyRepository;
import ru.yandex.partner.core.entity.block.repository.BlockTypedRepository;
import ru.yandex.partner.core.entity.block.service.type.update.BlockUpdateOperationTypeSupportFacade;
import ru.yandex.partner.core.entity.block.service.validation.type.BlockValidationTypeSupportFacade;
import ru.yandex.partner.core.multitype.service.validation.type.update.EditableFieldValidator;
import ru.yandex.partner.core.operation.container.OperationContainerConfigurer;

@Component
@ParametersAreNonnullByDefault
public class BlockUpdateOperationFactory {
    private final BlockTypedRepository typedRepository;

    private final BlockModifyRepository modifyRepository;

    private final BlockValidationTypeSupportFacade validationTypeSupportFacade;

    private final BlockUpdateOperationTypeSupportFacade updateOperationTypeSupportFacade;

    private final DSLContext dslContext;

    private final List<OperationContainerConfigurer<BlockContainer>> additionalContainerConfigurers;

    private final EditableFieldValidator<BaseBlock> editableFieldValidator;

    @SuppressWarnings("checkstyle:parameternumber")
    public BlockUpdateOperationFactory(
            BlockTypedRepository typedRepository,
            BlockModifyRepository modifyRepository,
            BlockValidationTypeSupportFacade validationTypeSupportFacade,
            BlockUpdateOperationTypeSupportFacade updateOperationTypeSupportFacade,
            DSLContext dslContext,
            List<OperationContainerConfigurer<BlockContainer>> additionalContainerConfigurers,
            EditableFieldValidator<BaseBlock> editableFieldValidator) {
        this.typedRepository = typedRepository;
        this.modifyRepository = modifyRepository;
        this.validationTypeSupportFacade = validationTypeSupportFacade;
        this.updateOperationTypeSupportFacade = updateOperationTypeSupportFacade;
        this.dslContext = dslContext;
        this.additionalContainerConfigurers = additionalContainerConfigurers;
        this.editableFieldValidator = editableFieldValidator;
    }

    public BlockUpdateOperation createUpdateOperationWithPreloadedModels(
            Applicability applicability,
            List<ModelChanges<BaseBlock>> modelChanges,
            IncomingFields incomingFields,
            Collection<BaseBlock> preloadedModels,
            Function<Long, BaseBlock> modelStubCreator
    ) {
        var blockUpdateOperation = new BlockUpdateOperation(
                applicability,
                modelChanges,
                incomingFields,
                dslContext,
                typedRepository,
                modifyRepository,
                updateOperationTypeSupportFacade,
                validationTypeSupportFacade,
                preloadedModels,
                editableFieldValidator,
                modelStubCreator
        );

        configureContainer(blockUpdateOperation.getContainer(), preloadedModels);
        return blockUpdateOperation;
    }

    private void configureContainer(BlockContainer container, Collection<BaseBlock> preloadedModels) {
        additionalContainerConfigurers.forEach(c ->
                c.configureContainer(container, preloadedModels));
    }

    /**
     * Используем только в случае, если осознаем последствия пустых incoming fields и preload models.
     */
    public BlockUpdateOperation createWithModelChangesOnly(List<ModelChanges<BaseBlock>> modelChanges) {
        return createUpdateOperationWithPreloadedModels(
                Applicability.FULL,
                modelChanges,
                new IncomingFields(),
                null,
                id -> null
        );
    }
}
