package ru.yandex.partner.core.entity.block.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.partner.core.entity.block.container.BlockContainer;
import ru.yandex.partner.core.entity.block.container.BlockContainerImpl;
import ru.yandex.partner.core.entity.block.model.BaseBlock;
import ru.yandex.partner.core.entity.block.service.validation.type.BlockValidationTypeSupportFacade;

@Service
public class BlockValidationService {
    private final BlockValidationTypeSupportFacade validationFacade;

    @Autowired
    public BlockValidationService(BlockValidationTypeSupportFacade validationFacade) {
        this.validationFacade = validationFacade;
    }

    /**
     * Метод принудительно наполняет контейнер данными (словарей и пр.), которые необходимы для валидации
     * В обычном режиме данные подтягиваются перед вызовом метода validate конкретного support'а в фасаде
     *
     * @param container - контейнер с общими данными
     */
    public void forceFillContainerByValidationSupports(BlockContainer container) {
        // Вызываем принудительную наливку данных всеми typesupport'ами
        validationFacade.forceFillContainerByValidationSupports(container);
    }

    public ValidationResult<List<? extends BaseBlock>, Defect> validate(
            List<? extends BaseBlock> models, BlockContainer container) {
        ValidationResult<List<? extends BaseBlock>, Defect> vr = new ValidationResult<>(models);
        validationFacade.validate(container, vr);
        return vr;
    }

    public ValidationResult<List<? extends BaseBlock>, Defect> validateAsCron(
            List<? extends BaseBlock> models, BlockContainer containerWithAllDict) {
        return validate(models, BlockContainerImpl.copy(containerWithAllDict));
    }
}
