package ru.yandex.partner.core.entity.block.service.type.add;

import org.jooq.DSLContext;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.IncomingFields;
import ru.yandex.partner.core.entity.block.container.BlockAdditionalActionsContainer;
import ru.yandex.partner.core.entity.block.container.BlockContainer;
import ru.yandex.partner.core.entity.block.container.BlockContainerImpl;
import ru.yandex.partner.core.entity.block.model.BaseBlock;
import ru.yandex.partner.core.entity.block.repository.BlockModifyRepository;
import ru.yandex.partner.core.entity.block.service.OperationMode;
import ru.yandex.partner.core.entity.block.service.validation.type.BlockValidationTypeSupportFacade;
import ru.yandex.partner.core.operation.factory.PartnerAddOperationFactory;

@Component
public class BlockAddOperationFactory
        extends PartnerAddOperationFactory<BaseBlock, BlockAdditionalActionsContainer, BlockContainer> {

    public BlockAddOperationFactory(
            DSLContext dslContext,
            BlockAddOperationTypeSupportFacade blockAddOperationTypeSupportFacade,
            BlockValidationTypeSupportFacade blockValidationTypeSupportFacade,
            BlockModifyRepository blockModifyRepository
    ) {
        super(
                dslContext,
                blockAddOperationTypeSupportFacade,
                blockValidationTypeSupportFacade,
                blockModifyRepository
        );
    }

    public BlockContainer prepareAddOperationContainer(
            OperationMode mode,
            IncomingFields incomingFields
    ) {
        var container = BlockContainerImpl.create(mode);
        container.setIncomingFields(incomingFields);
        return container;
    }

}
