package ru.yandex.partner.core.entity.block.service.type.update;

import java.util.Set;

import ru.yandex.direct.model.AppliedChanges;
import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.model.ModelProperty;
import ru.yandex.partner.core.block.BlockType;
import ru.yandex.partner.core.entity.block.container.BlockContainer;
import ru.yandex.partner.core.entity.block.model.BaseBlock;
import ru.yandex.partner.core.multitype.repository.PartnerRepositoryTypeSupportFacade;
import ru.yandex.partner.core.typesupport.update.PartnerBaseUpdateOperationTypeSupport;

public abstract class AbstractBlockUpdateOperationTypeSupport<B extends BaseBlock>
        extends PartnerBaseUpdateOperationTypeSupport<
        B,
        BlockContainer,
        BlockContainer,
        BlockContainer>
        implements BlockUpdateOperationTypeSupport<B> {

    public AbstractBlockUpdateOperationTypeSupport(PartnerRepositoryTypeSupportFacade<BaseBlock, BlockType,
            BlockContainer, BlockContainer> repositoryFacade) {
        super(repositoryFacade);
    }

    public Set<ModelProperty<? super B, ?>> needBsResyncProps() {
        return Set.of();
    }

    @Override
    public boolean needBsResync(AppliedChanges<B> appliedChanges) {
        var resyncProps = needBsResyncProps();

        if (resyncProps.isEmpty()) {
            return false;
        }

        return appliedChanges.getActuallyChangedProps().stream()
                .anyMatch(resyncProps::contains);
    }

    public boolean needBsResync(ModelChanges<B> appliedChanges) {
        var resyncProps = needBsResyncProps();

        if (resyncProps.isEmpty()) {
            return false;
        }

        return appliedChanges.getChangedPropsNames().stream()
                .anyMatch(resyncProps::contains);
    }
}
