package ru.yandex.partner.core.entity.block.service.type.update;

import java.util.Collection;
import java.util.List;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.collect.Lists;
import one.util.streamex.EntryStream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.model.Model;
import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.model.ModelProperty;
import ru.yandex.partner.core.entity.block.container.BlockContainer;
import ru.yandex.partner.core.entity.block.container.BlockContainerImpl;
import ru.yandex.partner.core.entity.block.model.BaseBlock;
import ru.yandex.partner.core.entity.block.repository.type.BlockRepositoryTypeSupportFacade;
import ru.yandex.partner.core.entity.block.service.OperationMode;
import ru.yandex.partner.core.operation.CoreModelAwareUpdateOperationTypeSupportFacade;
import ru.yandex.partner.core.operation.CoreModelProvider;

import static ru.yandex.direct.utils.FunctionalUtils.filterAndMapToSet;

@Component
@ParametersAreNonnullByDefault
public class BlockUpdateOperationTypeSupportFacade
        extends CoreModelAwareUpdateOperationTypeSupportFacade<BaseBlock, BlockContainer,
        BlockContainer, BlockContainer> {

    @Autowired
    public BlockUpdateOperationTypeSupportFacade(
            List<BlockUpdateOperationTypeSupport<? extends BaseBlock>> supports,
            List<CoreModelProvider<? extends BaseBlock>> coreModels,
            BlockRepositoryTypeSupportFacade blockRepositoryTypeSupportFacade
    ) {
        super(supports, coreModels, blockRepositoryTypeSupportFacade);
    }

    public Set<Long> getNeedBsResyncIdsByModelChanges(
            Collection<? extends ModelChanges<? extends BaseBlock>> modelChanges) {
        return EntryStream.of(getModelChangesGroupedByTypeSupports(
                        BlockContainerImpl.create(OperationMode.EDIT), modelChanges))
                .filterKeys(support -> support instanceof AbstractBlockUpdateOperationTypeSupport)
                .mapKeys(AbstractBlockUpdateOperationTypeSupport.class::cast)
                .mapKeyValue(this::getNeedBsResyncIdsByModelChanges)
                .flatMap(Collection::stream)
                .toSet();
    }

    private <M extends BaseBlock> Set<Long> getNeedBsResyncIdsByModelChanges(
            AbstractBlockUpdateOperationTypeSupport<M> support,
            List<? extends ModelChanges<? extends BaseBlock>> modelChanges) {

        List<ModelChanges<M>> typedModelChanges =
                Lists.transform(modelChanges, mc -> mc.castModel(support.getTypeClass()));

        return filterAndMapToSet(typedModelChanges, support::needBsResync, ModelChanges::getId);
    }

    public <B extends BaseBlock> Set<ModelProperty<? extends Model, ?>> getAffectedProps(
            Collection<? extends ModelChanges<? extends BaseBlock>> modelChanges, Class<B> blockClass) {

        return EntryStream.of(getModelChangesGroupedByTypeSupports(
                        BlockContainerImpl.create(OperationMode.EDIT), modelChanges))
                .filterKeys(support -> support.getTypeClass().isAssignableFrom(blockClass))
                .filterKeys(support -> support instanceof AbstractBlockUpdateOperationTypeSupport)
                .mapKeys(AbstractBlockUpdateOperationTypeSupport.class::cast)
                .mapKeys(ts -> (Set<ModelProperty<? extends Model, ?>>) ts.getAffectedProps())
                .keys()
                .flatMap(Set::stream)
                .toSet();
    }
}
