package ru.yandex.partner.core.entity.block.service.validation.defects;

import ru.yandex.direct.validation.result.DefectId;

public class BlockDefectIds {
    public enum Strategy implements DefectId<StrategyDefectParams> {
        INCORRECT_MINCPM_VALUE,
        INCORRECT_STRATEGY_VALUE,
        MINCPM_VALUE_RANGE,
        ADS_CPM_VALUE_RANGE,

        EMPTY_STRATEGY,
        NOT_ACTIVE_ADS,
        ALL_ADS_BLOCKED
    }

    public enum Adfox implements DefectId<Void> {
        PRIVATE_AUCTION_INVALID_VALUE,
    }

    public enum AltSize implements DefectId<Void> {
        EMPTY_HEIGHT,
        EMPTY_WIDTH,
    }

    public enum VoidDefectIds implements DefectId<Void> {
        ID_IS_NULL,
        PAGE_ID_IS_NULL,
        BLOCK_ID_IS_NULL,
        PUBLIC_ID_IS_NULL,
        UNIQUE_ID_IS_INVALID,
        UNKNOWN_BLOCK_TYPE,
    }

    public enum LongDefects implements DefectId<Long> {
        PAGE_ID_UNREACHABLE
    }

    public enum DspBlocks implements DefectId<DspBlocksDefectParams> {
        INVALID_DSP_BLOCK_TYPES,
        HAS_DUPLICATES,
        BAD_DSP_BLOCKS,
    }

    public enum SiteVersionDefectId implements DefectId<BlockSimpleDefectParam> {
        INVALID_SITE_VERSION,
        UNAVAILABLE_SITE_VERSION
    }

    public enum Dsps implements DefectId<DspsDefectParams> {
        EMPTY_DSPS_FOR_VIDEO_AD,
        HAS_DUPLICATES,
        HAS_NOT_FOUND,
        EMPTY_BLACK_WHITE_LIST
    }

    public enum DspsUnmoderated implements DefectId<DspsUnmoderatedDefectParams> {
        HAS_NOT_AVAILABLED,
        HAS_NOT_UNMODERATED,
        PAGE_HAS_NOT_FLAG_UNMODERATED
    }

    public enum BrandDefectIds implements DefectId<Void> {
        CPM_SET_FOR_BLOCKED,
        CPM_NOT_SET_FOR_NON_BLOCKED
    }

    public enum DesignTemplates implements DefectId<DesignTemplatesDefectParams> {
        EMPTY_DESIGN_TEMPLATES,
        INVALID_SET_OF_NATIVE_DESIGN,
        TOO_FEW_DESIGNS,
        TOO_MANY_DESIGNS,
        INVALID_DESIGN_TYPE,
        MSF_FAILED,
        INVALID_GREED,
        NOT_AVAILABLE_DESIGN_SETTING,
        INVALID_VIDEO_SETTINGS,
        TYPE_FIELD_CHANGES,
        KEY_REQUIRED,
        UNKNOWN_KEY,
        VALUE_MUST_BE_NUMBER
    }
    public enum OptsDefectIds implements DefectId<BlockSimpleDefectParam> {
        NON_EXISTED_TAGS,
        SOME_OPTIONS_ARE_UNAVAILABLE,
        SOME_OPTIONS_HAVE_CONFLICT_CHANGES
    }

    public enum JsonDefectIds implements DefectId<Void> {
        INCORRECT_JSON
    }

    public enum BkDataDefects implements DefectId<BlockSimpleDefectParam> {
        BAD_DESIGNS,
        INCORRECT_CUSTOM_BK_DATA
    }

    public enum DesignTemplatesUpdateDefects implements DefectId<Void> {
        DESIGN_TEMPLATES_UPDATE_FAILED
    }

    public enum PageDefects implements DefectId<BlockSimpleDefectParam> {
        PAGE_NOT_FOUND
    }
    public enum DesignSettings implements DefectId<DesignSettingsDefectParams> {
        DESIGN_SETTINGS_CANNOT_PARSE
    }

    public enum BlockTypeDefects implements DefectId<BlockTypeDefects.Param> {
        INVALID_BLOCK_TYPE_VALUE;

        public record Param(String param) implements SimpleParamGetter {
            @Override
            public String getParam() {
                return param;
            }
        }
    }

    public enum DirectBlockDefects implements DefectId<Void> {
        INVALID_DIRECT_BLOCK_TYPE
    }
}
