package ru.yandex.partner.core.entity.block.service.validation.defects;

import ru.yandex.direct.validation.result.Defect;
import ru.yandex.partner.dbschema.partner.enums.DesignTemplatesType;

public class BlockDefects {
    private BlockDefects() {

    }

    public static Defect<StrategyDefectParams> emptyStrategy() {
        return new Defect<>(BlockDefectIds.Strategy.EMPTY_STRATEGY);
    }

    public static Defect<Void> nullId() {
        return new Defect<>(BlockDefectIds.VoidDefectIds.ID_IS_NULL);
    }

    public static Defect<Void> nullPageId() {
        return new Defect<>(BlockDefectIds.VoidDefectIds.PAGE_ID_IS_NULL);
    }

    public static Defect<Long> pageUnreachable(long id) {
        return new Defect<>(BlockDefectIds.LongDefects.PAGE_ID_UNREACHABLE, id);
    }

    public static Defect<Void> nullBlockId() {
        return new Defect<>(BlockDefectIds.VoidDefectIds.BLOCK_ID_IS_NULL);
    }

    public static Defect<Void> invalidUniqueId() {
        return new Defect<>(BlockDefectIds.VoidDefectIds.UNIQUE_ID_IS_INVALID);
    }

    public static Defect<Void> unknownBlockType() {
        return new Defect<>(BlockDefectIds.VoidDefectIds.UNKNOWN_BLOCK_TYPE);
    }

    public static Defect<Void> invalidPrivateAuctionValue() {
        return new Defect<>(BlockDefectIds.Adfox.PRIVATE_AUCTION_INVALID_VALUE);
    }

    public static Defect<Void> emptyAltWidht() {
        return new Defect<>(BlockDefectIds.AltSize.EMPTY_WIDTH);
    }

    public static Defect<Void> emptyAltHeight() {
        return new Defect<>(BlockDefectIds.AltSize.EMPTY_HEIGHT);
    }

    public static Defect<Void> brandCpmSetForBlocked() {
        return new Defect<>(BlockDefectIds.BrandDefectIds.CPM_SET_FOR_BLOCKED);
    }

    public static Defect<Void> brandCpmNotSetForNonBlocked() {
        return new Defect<>(BlockDefectIds.BrandDefectIds.CPM_NOT_SET_FOR_NON_BLOCKED);
    }


    public static Defect<DesignTemplatesDefectParams> emptyDesignTemplates() {
        return new Defect<>(BlockDefectIds.DesignTemplates.EMPTY_DESIGN_TEMPLATES);
    }

    public static Defect<DesignTemplatesDefectParams> invalidSetOfNativeDesign() {
        return new Defect<>(BlockDefectIds.DesignTemplates.INVALID_SET_OF_NATIVE_DESIGN);
    }

    public static Defect<DesignTemplatesDefectParams> designTypeMustBySet(DesignTemplatesType type) {
        return new Defect<>(BlockDefectIds.DesignTemplates.TOO_FEW_DESIGNS,
                new DesignTemplatesDefectParams().withDesignType(type.getLiteral()));
    }

    public static Defect<DesignTemplatesDefectParams> tooManyDesigns(DesignTemplatesType type, int max) {
        return new Defect<>(BlockDefectIds.DesignTemplates.TOO_MANY_DESIGNS,
                new DesignTemplatesDefectParams().withMax(max).withDesignType(type.getLiteral()));
    }

    public static Defect<DesignTemplatesDefectParams> invalidDesignType(DesignTemplatesType type) {
        return new Defect<>(BlockDefectIds.DesignTemplates.INVALID_DESIGN_TYPE,
                new DesignTemplatesDefectParams().withDesignType(type.getLiteral()));
    }

    public static Defect<DesignTemplatesDefectParams> msfDefect(String message) {
        return new Defect<>(BlockDefectIds.DesignTemplates.MSF_FAILED,
                new DesignTemplatesDefectParams().withMessage(message));
    }

    public static Defect<DesignTemplatesDefectParams> msfDefect(String key, String message) {
        return new Defect<>(BlockDefectIds.DesignTemplates.MSF_FAILED,
                new DesignTemplatesDefectParams().withKey(key).withMessage(message));
    }

    public static Defect<DesignTemplatesDefectParams> keyRequired(String key) {
        return new Defect<>(BlockDefectIds.DesignTemplates.KEY_REQUIRED,
                new DesignTemplatesDefectParams().withKey(key));
    }

    public static Defect<DesignTemplatesDefectParams> unknownKey(String key) {
        return new Defect<>(BlockDefectIds.DesignTemplates.UNKNOWN_KEY,
                new DesignTemplatesDefectParams().withKey(key));
    }

    public static Defect<BlockSimpleDefectParam> badDesigns(String badIds) {
        return new Defect<>(BlockDefectIds.BkDataDefects.BAD_DESIGNS,
                new BlockSimpleDefectParam().withParam(badIds));
    }

}
