package ru.yandex.partner.core.entity.block.service.validation.defects;

import java.util.Collection;
import java.util.Objects;

public class DspBlocksDefectParams {
    private Collection<String> duplicates;
    private Collection<String> badBlocks;


    public Collection<String> getDuplicates() {
        return duplicates;
    }

    public DspBlocksDefectParams withDuplicates(Collection<String> duplicates) {
        this.duplicates = duplicates;
        return this;
    }

    public Collection<String> getBadBlocks() {
        return badBlocks;
    }

    public DspBlocksDefectParams withBadBlocks(Collection<String> badBlocks) {
        this.badBlocks = badBlocks;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DspBlocksDefectParams)) {
            return false;
        }
        DspBlocksDefectParams that = (DspBlocksDefectParams) o;
        return Objects.equals(duplicates, that.duplicates) &&
                Objects.equals(badBlocks, that.badBlocks);
    }

    @Override
    public int hashCode() {
        return Objects.hash(duplicates, badBlocks);
    }

    @Override
    public String toString() {
        return "DspBlocksDefectParams{" +
                "duplicates=" + duplicates +
                ", badBlocks=" + badBlocks +
                '}';
    }
}
