package ru.yandex.partner.core.entity.block.service.validation.defects;

import java.util.Collection;
import java.util.Objects;
import java.util.StringJoiner;

public class DspsDefectParams {
    private Collection<Long> duplicates;
    private Collection<Long> notFound;

    public Collection<Long> getDuplicates() {
        return duplicates;
    }

    public DspsDefectParams withDuplicates(Collection<Long> duplicates) {
        this.duplicates = duplicates;
        return this;
    }

    public Collection<Long> getNotFound() {
        return notFound;
    }

    public DspsDefectParams withNotFound(Collection<Long> notFound) {
        this.notFound = notFound;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DspsDefectParams that = (DspsDefectParams) o;
        return Objects.equals(duplicates, that.duplicates) && Objects.equals(notFound, that.notFound);
    }

    @Override
    public int hashCode() {
        return Objects.hash(duplicates, notFound);
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", DspsDefectParams.class.getSimpleName() + "[", "]")
                .add("duplicates=" + duplicates)
                .add("notFound=" + notFound)
                .toString();
    }
}
