package ru.yandex.partner.core.entity.block.service.validation.defects;

import java.util.Collection;
import java.util.Objects;
import java.util.StringJoiner;

public class DspsUnmoderatedDefectParams {
    private Collection<Long> notAvailable;
    private Collection<Long> notUnmoderated;

    public Collection<Long> getNotAvailable() {
        return notAvailable;
    }

    public DspsUnmoderatedDefectParams withNotAvailabled(Collection<Long> notAvailable) {
        this.notAvailable = notAvailable;
        return this;
    }

    public Collection<Long> getNotUnmoderated() {
        return notUnmoderated;
    }

    public DspsUnmoderatedDefectParams withNotUnmoderated(Collection<Long> notUnmoderated) {
        this.notUnmoderated = notUnmoderated;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DspsUnmoderatedDefectParams that = (DspsUnmoderatedDefectParams) o;
        return Objects.equals(notAvailable, that.notAvailable) && Objects.equals(notUnmoderated, that.notUnmoderated);
    }

    @Override
    public int hashCode() {
        return Objects.hash(notAvailable, notUnmoderated);
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", DspsUnmoderatedDefectParams.class.getSimpleName() + "[", "]")
                .add("notAvailable=" + notAvailable)
                .add("notUnmoderated=" + notUnmoderated)
                .toString();
    }
}
