package ru.yandex.partner.core.entity.block.service.validation.defects;

import java.math.BigDecimal;
import java.util.Objects;

public class StrategyDefectParams {
    private BigDecimal minMinCpm;
    private BigDecimal maxMinCpm;
    private String cpmName;

    public StrategyDefectParams withMinCpm(BigDecimal minMinCpm) {
        this.minMinCpm = minMinCpm;
        return this;
    }

    public Long getMaxMinCpmAsLong() {
        return maxMinCpm != null
                ? maxMinCpm.longValue()
                : null;
    }

    public StrategyDefectParams withMaxCpm(BigDecimal maxMinCpm) {
        this.maxMinCpm = maxMinCpm;
        return this;
    }

    public String getCpmName() {
        return cpmName;
    }

    public StrategyDefectParams withCpmName(String cpmName) {
        this.cpmName = cpmName;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StrategyDefectParams)) {
            return false;
        }
        StrategyDefectParams that = (StrategyDefectParams) o;
        return Objects.equals(minMinCpm, that.minMinCpm) &&
                Objects.equals(maxMinCpm, that.maxMinCpm) &&
                Objects.equals(cpmName, that.cpmName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(minMinCpm, maxMinCpm, cpmName);
    }

    @Override
    public String toString() {
        return "StrategyDefectParams{" +
                "minMinCpm=" + minMinCpm +
                ", maxMinCpm=" + maxMinCpm +
                ", cpmName='" + cpmName + '\'' +
                '}';
    }
}
