package ru.yandex.partner.core.entity.block.service.validation.defects.presentation;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.partner.libs.i18n.GettextMsg;
import ru.yandex.partner.libs.i18n.GettextMsgPayload;

import static ru.yandex.partner.libs.i18n.GettextMsgPayload.Builder.msg;

@ParametersAreNonnullByDefault
public enum BkDataValidationMsg implements GettextMsg {
    BAD_DESIGNS(msg("Bad design id's: %s"), "lib__Application__Model__Role__Has__Block__DesignTemplates.pm"),
    INCORRECT_CUSTOM_BK_DATA(msg("Incorrect custom bk data"),
            "lib__Application__Model__Product__InternalAN__InternalContextOnSite__RTB.pm"),
    NON_PARSEABLE_BK_DATA(msg("Could not parse bkdata: %s"), Constants.BK_DATA_BLOCK_KEYSET),
    MISSING_KEY(msg("Missing key \"%s\""), Constants.BK_DATA_BLOCK_KEYSET),
    UNKNOWN_DSP(msg("DSP with DSPID = %s doesn't exist in DB"), Constants.BK_DATA_BLOCK_KEYSET),
    INCORRECT_DSP_TYPE(msg("Block %s has DSPType = %s, DSP %s has DSPType = %s"), Constants.BK_DATA_BLOCK_KEYSET),
    PAGE_VIDEO_NOT_SUPPORTED(msg("Block %s has Video field, but current page doesnt have RtbVideo field"),
            Constants.BK_DATA_BLOCK_KEYSET),
    WRONG_VIDEO_TYPE(msg("Wrong block.Video subfield Type"), Constants.BK_DATA_BLOCK_KEYSET),
    SIZES_MISSING(msg("Width and Height of PageID=%s ImpID=%s undefined or null"), Constants.BK_DATA_BLOCK_KEYSET),
    INCORRECT_AD_TYPE_SET(msg("AdTypeSet %s of PageID=%s ImpID=%s incorrect"), Constants.BK_DATA_BLOCK_KEYSET),
    MISSING_AD_TYPE_SET(msg("AdTypeSet %s of PageID=%s ImpID=%s (interstitial) incorrect or not found"),
            Constants.BK_DATA_BLOCK_KEYSET),
    NONSENSE_AD_TYPE_SET(msg("Nonsense in AdType %s of PageID=%s ImpID=%s"),
            Constants.BK_DATA_BLOCK_KEYSET),
    VPA_ID_DISABLED_AND_AD_TYPES_NOT_SET(msg("AdTypeSet %s of PageID=%s ImpID=%s (VPAIDEnabled=false and all " +
            "AdTypeSet values is false)"),
            Constants.BK_DATA_BLOCK_KEYSET),
    SIZES_INCORRECT_OR_NOT_FOUND(msg("Sizes %s of PageID=%s ImpID=%s (interstitial) incorrect or not found"),
            Constants.BK_DATA_BLOCK_KEYSET),
    DIRECT_LIMIT_INCORRECT(msg("DirectLimit of PageID=%s ImpID=%s incorrect"), Constants.BK_DATA_BLOCK_KEYSET),
    WRONG_RTB_VIDEO_FIELD(msg("Wrong RtbVideo field"), Constants.BK_DATA_BLOCK_KEYSET),
    WRONG_ARCHIVE(msg("RtbVideo.Categories.%s.Archive not exists or wrong"), Constants.BK_DATA_BLOCK_KEYSET),
    WRONG_NAME(msg("RtbVideo.Categories.%s.Name not exists or empty"), Constants.BK_DATA_BLOCK_KEYSET),
    SSP_REQUIRED(msg("Parameters 'SSPPageToken' and 'SSPID' is required"), Constants.BK_DATA_PAGE_KEYSET),
    INCORRECT_SSP(msg("Some token in parameter 'SSPPageToken' incorrect"), Constants.BK_DATA_PAGE_KEYSET),
    DUPLICATE_SSP_TOKEN(msg("Exists SSPID with this Token for PageID=%s"), Constants.BK_DATA_PAGE_KEYSET),
    EXCESS_SSP_PARAMS(msg("Parameters 'SSPPageToken' or 'SSPID' is excess"), Constants.BK_DATA_PAGE_KEYSET),
    UNMODIFIABLE_PAGE(msg("You don't have permissions to edit this page(%s)"), Constants.BK_DATA_PAGE_KEYSET),
    WRONG_PRODUCT_TYPE(msg("Undefined or wrong ProductType: %s"), Constants.BK_DATA_PAGE_KEYSET),
    INVALID_CPA(msg("Invalid CPA value (%s) - must be >= 0 and <= 100"), Constants.BK_DATA_PAGE_KEYSET),
    STRIPE_NOT_DEFINED(msg("'StripeType' or 'StripeAnimation' key for PlaceID %s is undef"),
            Constants.BK_DATA_PAGE_KEYSET),
    INVALID_RELOAD_TIMEOUT(msg("Invalid 'ReloadTimeout' value - must be in [1 .. 30]"), Constants.BK_DATA_PAGE_KEYSET),
    INCORRECT_LANG(msg("Parameter 'Lang' is incorrect"), Constants.BK_DATA_PAGE_KEYSET),
    INCORRECT_STORE(msg("Parameter 'Store' incorrect"), Constants.BK_DATA_PAGE_KEYSET);


    private final GettextMsgPayload payload;
    private final String keyset;

    BkDataValidationMsg(GettextMsgPayload.Builder builder, String keyset) {
        this(builder.build(), keyset);
    }

    BkDataValidationMsg(GettextMsgPayload payload, String keyset) {
        this.payload = payload;
        this.keyset = keyset;
    }

    @Nonnull
    @Override
    public GettextMsgPayload getPayload() {
        return payload;
    }

    @Nonnull
    @Override
    public String getKeysetName() {
        return keyset;
    }


    private static class Constants {
        private static final String BK_DATA_BLOCK_KEYSET = "lib__QBit__Validator__Type__bk_data__block.pm";
        private static final String BK_DATA_PAGE_KEYSET = "lib__QBit__Validator__Type__bk_data__page.pm";
    }
}
