package ru.yandex.partner.core.entity.block.service.validation.defects.presentation;

import java.util.stream.Collectors;

import ru.yandex.direct.validation.presentation.DefaultDefectPresentationRegistry;
import ru.yandex.direct.validation.result.DefectIds;
import ru.yandex.partner.core.entity.block.actions.defects.BlockActionDefectIds;
import ru.yandex.partner.core.entity.block.actions.defects.presentation.BlockActionDefectMsg;
import ru.yandex.partner.core.entity.block.actions.defects.presentation.BlockFieldsDefectMsg;
import ru.yandex.partner.core.entity.block.service.validation.defects.BlockDefectIds;
import ru.yandex.partner.core.entity.page.service.validation.defects.presentation.PageValidationMsg;
import ru.yandex.partner.core.validation.defects.presentation.CommonValidationMsg;
import ru.yandex.partner.libs.i18n.MsgWithArgs;
import ru.yandex.partner.libs.i18n.TranslatableError;

import static ru.yandex.partner.core.validation.defects.presentation.DefectPresentationProviders.defaultDefectProvider;
import static ru.yandex.partner.core.validation.defects.presentation.DefectPresentationProviders.getParamProvider;
import static ru.yandex.partner.core.validation.defects.presentation.DefectPresentationProviders.getProvider;
import static ru.yandex.partner.core.validation.defects.presentation.DefectPresentationProviders.passThroughParamProvider;

public class BlockDefectPresentationRegistry {
    private BlockDefectPresentationRegistry() {
    }

    @SuppressWarnings("checkstyle:methodlength")
    public static DefaultDefectPresentationRegistry<TranslatableError> blockDefectPresentationRegistry() {
        return DefaultDefectPresentationRegistry.builder()
                .register(BlockDefectIds.AltSize.EMPTY_HEIGHT, defaultDefectProvider(BlockValidationMsg.EMPTY_HEIGHT))
                .register(BlockDefectIds.AltSize.EMPTY_WIDTH, defaultDefectProvider(BlockValidationMsg.EMPTY_WIDTH))
                .register(BlockDefectIds.Strategy.INCORRECT_STRATEGY_VALUE,
                        defaultDefectProvider(StrategyValidationMsg.INCORRECT_STRATEGY_VALUE))
                .register(BlockDefectIds.Strategy.MINCPM_VALUE_RANGE,
                        getProvider(
                                defectInfo -> MsgWithArgs.of(
                                        StrategyValidationMsg.MINCPM_VALUE_RANGE,
                                        defectInfo.getDefect().params().getMaxMinCpmAsLong())
                        ))
                .register(BlockDefectIds.Strategy.INCORRECT_MINCPM_VALUE,
                        getProvider(
                                defectInfo -> MsgWithArgs.of(
                                        StrategyValidationMsg.INCORRECT_MINCPM_VALUE,
                                        defectInfo.getDefect().params().getMaxMinCpmAsLong())
                        ))
                .register(BlockDefectIds.Strategy.ADS_CPM_VALUE_RANGE,
                        getProvider(
                                defectInfo -> MsgWithArgs.of(
                                        StrategyValidationMsg.ADS_CPM_VALUE_RANGE,
                                        defectInfo.getDefect().params().getCpmName(),
                                        defectInfo.getDefect().params().getMaxMinCpmAsLong())
                        ))
                .register(BlockDefectIds.Strategy.NOT_ACTIVE_ADS,
                        defaultDefectProvider(StrategyValidationMsg.SHOULD_SET_CPM_OR_BLOCK_ADS))
                .register(BlockDefectIds.Strategy.ALL_ADS_BLOCKED,
                        defaultDefectProvider(StrategyValidationMsg.CANNOT_BLOCKED_ALL_ADS))

                .register(BlockDefectIds.DspBlocks.INVALID_DSP_BLOCK_TYPES,
                        defaultDefectProvider(DspBlocksValidationMsg.INVALID_DSP_BLOCK_TYPES))
                .register(BlockDefectIds.DspBlocks.HAS_DUPLICATES,
                        getProvider(defectInfo ->
                                MsgWithArgs.of(DspBlocksValidationMsg.GOT_DUPLICATES,
                                        String.join(", ", defectInfo.getDefect().params().getDuplicates()))
                        ))
                .register(BlockDefectIds.DspBlocks.BAD_DSP_BLOCKS,
                        getProvider(defectInfo ->
                                MsgWithArgs.of(DspBlocksValidationMsg.INVALID_DSP_BLOCK_TYPES_S,
                                        String.join(", ", defectInfo.getDefect().params().getBadBlocks()))
                        ))
                .register(BlockDefectIds.SiteVersionDefectId.INVALID_SITE_VERSION,
                        getParamProvider(SiteVersionValidationMsg.INVALID_SITE_VERSION))
                .register(BlockDefectIds.SiteVersionDefectId.UNAVAILABLE_SITE_VERSION,
                        getParamProvider(SiteVersionValidationMsg.UNAVAILABLE_SITE_VERSION))
                .register(BlockDefectIds.BrandDefectIds.CPM_SET_FOR_BLOCKED,
                        defaultDefectProvider(BrandValidationMsg.UNEXPECTED_CPM))
                .register(BlockDefectIds.BrandDefectIds.CPM_NOT_SET_FOR_NON_BLOCKED,
                        defaultDefectProvider(BrandValidationMsg.CPM_REQUIRED))
                .register(BlockDefectIds.DesignTemplates.EMPTY_DESIGN_TEMPLATES,
                        defaultDefectProvider(DesignTemplatesValidationMsg.EMPTY_DESIGN_TEMPLATES))
                .register(BlockDefectIds.DesignTemplates.INVALID_SET_OF_NATIVE_DESIGN,
                        defaultDefectProvider(DesignTemplatesValidationMsg.INVALID_SET_OF_NATIVE_DESIGN))
                .register(BlockDefectIds.DesignTemplates.TOO_FEW_DESIGNS,
                        getProvider(
                                defectInfo -> MsgWithArgs.of(
                                        DesignTemplatesValidationMsg.TOO_FEW_DESIGNS,
                                        defectInfo.getDefect().params().getDesignType())
                        ))
                .register(BlockDefectIds.DesignTemplates.TOO_MANY_DESIGNS,
                        getProvider(
                                defectInfo -> MsgWithArgs.of(
                                        DesignTemplatesValidationMsg.TOO_MANY_DESIGNS,
                                        defectInfo.getDefect().params().getDesignType(),
                                        defectInfo.getDefect().params().getMax())
                        ))
                .register(BlockDefectIds.DesignTemplates.INVALID_DESIGN_TYPE,
                        getProvider(
                                defectInfo -> MsgWithArgs.of(
                                        DesignTemplatesValidationMsg.INVALID_DESIGN_TYPE,
                                        defectInfo.getDefect().params().getDesignType())
                        ))
                .register(BlockDefectIds.DesignTemplates.MSF_FAILED,
                        getProvider(
                                defectInfo -> MsgWithArgs.of(
                                        DesignTemplatesValidationMsg.MSF_FAILED,
                                        defectInfo.getDefect().params().getMessage())
                        ))
                .register(BlockDefectIds.DesignTemplates.INVALID_GREED,
                        defaultDefectProvider(DesignTemplatesValidationMsg.INVALID_GREED))
                .register(BlockDefectIds.DesignTemplates.NOT_AVAILABLE_DESIGN_SETTING,
                        defaultDefectProvider(DesignTemplatesValidationMsg.NOT_AVAILABLE_DESIGN_SETTING))
                .register(BlockDefectIds.DesignTemplates.INVALID_VIDEO_SETTINGS,
                        getProvider(
                                defectInfo -> MsgWithArgs.of(
                                        DesignTemplatesValidationMsg.INVALID_VIDEO_SETTINGS,
                                        defectInfo.getDefect().params().getKey(),
                                        defectInfo.getDefect().params().getDesignType())
                        ))
                .register(BlockDefectIds.DesignTemplates.TYPE_FIELD_CHANGES,
                        defaultDefectProvider(DesignTemplatesValidationMsg.TYPE_FIELD_CHANGES))
                .register(BlockDefectIds.DesignTemplates.KEY_REQUIRED,
                        getProvider(
                                defectInfo -> MsgWithArgs.of(
                                        DesignTemplatesValidationMsg.KEY_REQUIRED,
                                        defectInfo.getDefect().params().getKey())
                        ))
                .register(BlockDefectIds.DesignTemplates.UNKNOWN_KEY,
                        getProvider(
                                defectInfo -> MsgWithArgs.of(
                                        CommonValidationMsg.UNKNOWN_KEY,
                                        defectInfo.getDefect().params().getKey())
                        ))
                .register(BlockDefectIds.DesignTemplates.VALUE_MUST_BE_NUMBER,
                        getProvider(
                                defectInfo -> MsgWithArgs.of(
                                        DesignTemplatesValidationMsg.VALUE_MUST_BE_NUMBER,
                                        defectInfo.getDefect().params().getKey())
                        ))

                .register(BlockDefectIds.OptsDefectIds.NON_EXISTED_TAGS,
                        getParamProvider(OptsValidationMsg.NON_EXISTED_TAGS))
                .register(BlockDefectIds.OptsDefectIds.SOME_OPTIONS_ARE_UNAVAILABLE,
                        defaultDefectProvider(OptsValidationMsg.SOME_OPTIONS_ARE_UNAVAILABLE))
                .register(BlockDefectIds.OptsDefectIds.SOME_OPTIONS_HAVE_CONFLICT_CHANGES,
                        defaultDefectProvider(OptsValidationMsg.SOME_OPTIONS_HAVE_CONFLICT_CHANGES))
                .register(BlockDefectIds.Dsps.HAS_DUPLICATES,
                        getProvider(
                                defectInfo -> MsgWithArgs.of(
                                        DspValidationMsg.HAS_DUPLICATES,
                                        defectInfo.getDefect().params().getDuplicates().stream()
                                                .map(Object::toString)
                                                .collect(Collectors.joining(", "))
                                )
                        )
                )
                .register(BlockDefectIds.Dsps.EMPTY_DSPS_FOR_VIDEO_AD,
                        defaultDefectProvider(DspValidationMsg.EMPTY_DSPS_FOR_VIDEO_AD))
                .register(BlockDefectIds.Dsps.HAS_NOT_FOUND,
                        getProvider(
                                defectInfo -> MsgWithArgs.of(
                                        DspValidationMsg.HAS_NOT_FOUND,
                                        defectInfo.getDefect().params().getNotFound().stream()
                                                .map(Object::toString)
                                                .collect(Collectors.joining(", "))
                                )
                        )
                )
                .register(BlockDefectIds.JsonDefectIds.INCORRECT_JSON,
                        defaultDefectProvider(CommonValidationMsg.INCORRECT_JSON))
                .register(BlockDefectIds.LongDefects.PAGE_ID_UNREACHABLE,
                        passThroughParamProvider(BlockValidationMsg.PAGE_ID_UNREACHABLE))
                .register(BlockDefectIds.DspsUnmoderated.HAS_NOT_UNMODERATED,
                        getProvider(
                                defectInfo -> MsgWithArgs.of(
                                        DspValidationMsg.HAS_NOT_UNMODERATED,
                                        defectInfo.getDefect().params().getNotUnmoderated())
                        ))
                .register(BlockDefectIds.DspsUnmoderated.HAS_NOT_AVAILABLED,
                        getProvider(
                                defectInfo -> MsgWithArgs.of(
                                        DspValidationMsg.HAS_NOT_AVAILABLED,
                                        defectInfo.getDefect().params().getNotAvailable())
                        ))
                .register(BlockDefectIds.DspsUnmoderated.PAGE_HAS_NOT_FLAG_UNMODERATED,
                        defaultDefectProvider(DspValidationMsg.PAGE_HAS_NOT_FLAG_UNMODERATED))
                .register(BlockActionDefectIds.BlockActionDefect.CAN_NOT_START_WITH_YOUR_AGREEMENT,
                        defaultDefectProvider(BlockActionDefectMsg.CAN_NOT_START_WITH_YOUR_AGREEMENT))
                .register(BlockActionDefectIds.BlockActionDefect.INVALID_AGREEMENT,
                        defaultDefectProvider(BlockActionDefectMsg.INVALID_AGREEMENT))
                .register(BlockActionDefectIds.BlockActionDefect.ARCHIVED_BLOCK,
                        defaultDefectProvider(BlockActionDefectMsg.ARCHIVED_BLOCK))
                .register(BlockDefectIds.BkDataDefects.BAD_DESIGNS,
                        getParamProvider(BkDataValidationMsg.BAD_DESIGNS))
                .register(BlockDefectIds.BkDataDefects.INCORRECT_CUSTOM_BK_DATA,
                        getParamProvider(BkDataValidationMsg.INCORRECT_CUSTOM_BK_DATA))
                .register(BlockDefectIds.DesignTemplatesUpdateDefects.DESIGN_TEMPLATES_UPDATE_FAILED,
                        defaultDefectProvider(DesignTemplatesOperationMsg.DESIGN_TEMPLATES_UPDATE_FAILED))
                .register(BlockDefectIds.PageDefects.PAGE_NOT_FOUND,
                        getParamProvider(PageValidationMsg.PAGE_NOT_FOUND))
                .register(BlockDefectIds.DesignSettings.DESIGN_SETTINGS_CANNOT_PARSE,
                        getProvider(
                                defectInfo -> MsgWithArgs.of(
                                        DesignSettingsValidationMsg.DESIGN_SETTINGS_CANNOT_PARSE,
                                        defectInfo.getDefect().params().getKey(),
                                        defectInfo.getDefect().params().getFormatJSType())
                        ))
                .register(BlockDefectIds.BlockTypeDefects.INVALID_BLOCK_TYPE_VALUE,
                        defaultDefectProvider(BlockFieldsDefectMsg.INVALID_BLOCK_TYPE))
                .register(BlockDefectIds.DirectBlockDefects.INVALID_DIRECT_BLOCK_TYPE,
                        defaultDefectProvider(BlockFieldsDefectMsg.INVALID_DIRECT_BLOCK))
                .register(DefectIds.FORBIDDEN_TO_CHANGE,
                        defaultDefectProvider(BlockFieldsDefectMsg.FORBIDDEN_TO_CHANGE))
                .register(BlockDefectIds.Dsps.EMPTY_BLACK_WHITE_LIST,
                        defaultDefectProvider(DspValidationMsg.EMPTY_BLACK_WHITE_LIST))
                .build();
    }
}
