package ru.yandex.partner.core.entity.block.service.validation.defects.presentation;

import javax.annotation.Nonnull;

import ru.yandex.partner.libs.i18n.GettextMsg;
import ru.yandex.partner.libs.i18n.GettextMsgPayload;

import static ru.yandex.partner.libs.i18n.GettextMsgPayload.Builder.msg;

public enum BlockValidationMsg implements GettextMsg {
    EMPTY_WIDTH(msg("Specify alt_width block its advertising"),
            "lib__Application__Model__Product__AN__ContextOnSite__RTB.pm"),
    EMPTY_HEIGHT(msg("Specify height block its advertising"),
            "lib__Application__Model__Product__AN__ContextOnSite__RTB.pm"),
    PAGE_ID_UNREACHABLE(msg("Can not find page: %s"), "lib__Application__Model__Block.pm"),
    PAGE_ID_EXPECTED(msg("Expected page_id"),
            "lib__Application__Model__Product__InternalAN__MobileApp__RTB.pm");


    private final GettextMsgPayload payload;
    private final String keyset;

    BlockValidationMsg(GettextMsgPayload.Builder builder, String keyset) {
        this(builder.build(), keyset);
    }

    BlockValidationMsg(GettextMsgPayload payload, String keyset) {
        this.payload = payload;
        this.keyset = keyset;
    }

    @Nonnull
    @Override
    public GettextMsgPayload getPayload() {
        return payload;
    }

    @Nonnull
    @Override
    public String getKeysetName() {
        return keyset;
    }
}
