package ru.yandex.partner.core.entity.block.service.validation.defects.presentation;

import javax.annotation.Nonnull;

import ru.yandex.partner.libs.i18n.GettextMsg;
import ru.yandex.partner.libs.i18n.GettextMsgPayload;

import static ru.yandex.partner.libs.i18n.GettextMsgPayload.Builder.msg;

public enum BrandValidationMsg implements GettextMsg {
    UNEXPECTED_CPM(msg("Unexpected field 'cpm' when 'blocked' is true"),
            "lib__QBit__Validator__Type__brands.pm"),
    CPM_REQUIRED(msg("Field 'cpm' required when 'blocked' is false"),
            "lib__QBit__Validator__Type__brands.pm");

    private final GettextMsgPayload payload;
    private final String keyset;

    BrandValidationMsg(GettextMsgPayload.Builder builder, String keyset) {
        this(builder.build(), keyset);
    }

    BrandValidationMsg(GettextMsgPayload payload, String keyset) {
        this.payload = payload;
        this.keyset = keyset;
    }

    @Nonnull
    @Override
    public GettextMsgPayload getPayload() {
        return payload;
    }

    @Nonnull
    @Override
    public String getKeysetName() {
        return keyset;
    }
}
