package ru.yandex.partner.core.entity.block.service.validation.defects.presentation;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.partner.libs.i18n.GettextMsg;
import ru.yandex.partner.libs.i18n.GettextMsgPayload;

import static ru.yandex.partner.libs.i18n.GettextMsgPayload.Builder.msg;

@ParametersAreNonnullByDefault
public enum DesignSettingsValidationMsg implements GettextMsg {
    DESIGN_SETTINGS_CANNOT_PARSE(msg("Unable to parse \"%s\" value, required type is \"%s\""),
            "lib__Application__Model__Role__Has__Block__DesignTemplates.pm");

    private final GettextMsgPayload payload;
    private final String keyset;

    DesignSettingsValidationMsg(GettextMsgPayload.Builder builder, String keyset) {
        this(builder.build(), keyset);
    }

    DesignSettingsValidationMsg(GettextMsgPayload payload, String keyset) {
        this.payload = payload;
        this.keyset = keyset;
    }

    @Nonnull
    @Override
    public GettextMsgPayload getPayload() {
        return payload;
    }

    @Nonnull
    @Override
    public String getKeysetName() {
        return keyset;
    }


}
