package ru.yandex.partner.core.entity.block.service.validation.defects.presentation;

import ru.yandex.partner.libs.i18n.GettextMsg;
import ru.yandex.partner.libs.i18n.GettextMsgPayload;

import static ru.yandex.partner.libs.i18n.GettextMsgPayload.Builder.msg;

public enum DesignTemplatesOperationMsg implements GettextMsg {
    DESIGN_TEMPLATES_UPDATE_FAILED(msg("Failed to save design templates"),
            "lib__Application__Model__Role__Has__Block__DesignTemplates.pm");

    private final GettextMsgPayload payload;
    private final String keyset;

    DesignTemplatesOperationMsg(GettextMsgPayload.Builder builder, String keyset) {
        this(builder.build(), keyset);
    }

    DesignTemplatesOperationMsg(GettextMsgPayload payload, String keyset) {
        this.payload = payload;
        this.keyset = keyset;
    }

    @Override
    public GettextMsgPayload getPayload() {
        return payload;
    }

    @Override
    public String getKeysetName() {
        return keyset;
    }
}
