package ru.yandex.partner.core.entity.block.service.validation.defects.presentation;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.partner.libs.i18n.GettextMsg;
import ru.yandex.partner.libs.i18n.GettextMsgPayload;

import static ru.yandex.partner.libs.i18n.GettextMsgPayload.Builder.msg;

@ParametersAreNonnullByDefault
public enum DesignTemplatesValidationMsg implements GettextMsg {
    EMPTY_DESIGN_TEMPLATES(msg("Block should have at least one design"),
            "lib__Application__Model__Role__Has__Block__DesignTemplates.pm"),
    INVALID_SET_OF_NATIVE_DESIGN(msg("You can not add native designs"),
            "lib__Application__Model__Role__Has__Block__DesignTemplates.pm"),
    TOO_FEW_DESIGNS(msg("Need set at least one %s design"),
            "lib__Application__Model__Role__Has__Block__DesignTemplates.pm"),
    TOO_MANY_DESIGNS(msg("Maximum count of %s designs is %s"),
            "lib__Application__Model__Role__Has__Block__DesignTemplates.pm"),
    INVALID_DESIGN_TYPE(msg("Can't use %s as type for design template"),
            "lib__QBit__Validator__Type__design_template.pm"),
    MSF_FAILED(msg("%s"), "lib__QBit__Validator.pm"),
    INVALID_GREED(msg("grid_columns * grid_rows should not exceed 25"),
            "lib__QBit__Validator__Type__design_template.pm"),
    NOT_AVAILABLE_DESIGN_SETTING(msg("You can not change this field"),
            "lib__QBit__Validator__Type__design_template.pm"),
    INVALID_VIDEO_SETTINGS(msg("Cannot set %s without %s"), "lib__QBit__Validator__Type__design_template.pm"),
    TYPE_FIELD_CHANGES(msg("Can't change type for design template"), "lib__QBit__Validator__Type__design_template.pm"),
    KEY_REQUIRED(msg("Field \"%s\" must be defined"), "lib__QBit__Validator.pm"),
    VALUE_MUST_BE_NUMBER(msg("Field \"%s\" value should be number"),
            "lib__Application__Model__Role__Has__Block__DesignTemplates.pm");

    private final GettextMsgPayload payload;
    private final String keyset;

    DesignTemplatesValidationMsg(GettextMsgPayload.Builder builder, String keyset) {
        this(builder.build(), keyset);
    }

    DesignTemplatesValidationMsg(GettextMsgPayload payload, String keyset) {
        this.payload = payload;
        this.keyset = keyset;
    }

    @Nonnull
    @Override
    public GettextMsgPayload getPayload() {
        return payload;
    }

    @Nonnull
    @Override
    public String getKeysetName() {
        return keyset;
    }


}
