package ru.yandex.partner.core.entity.block.service.validation.defects.presentation;

import javax.annotation.Nonnull;

import ru.yandex.partner.libs.i18n.GettextMsg;
import ru.yandex.partner.libs.i18n.GettextMsgPayload;

import static ru.yandex.partner.libs.i18n.GettextMsgPayload.Builder.msg;

public enum DspBlocksValidationMsg implements GettextMsg {
    INVALID_DSP_BLOCK_TYPES(msg("Invalid DSP block types"), "lib__Application__Model__Product__AN__MobileApp__RTB.pm"),
    INVALID_DSP_BLOCK_TYPES_S(msg("Invalid DSP block types: %s"), "lib__Application__Model__RTBMixin.pm"),
    GOT_DUPLICATES(msg("Got duplicates in \"dsp_blocks\": %s"), "lib__Application__Model__RTBMixin.pm");


    private final GettextMsgPayload payload;
    private final String keyset;

    DspBlocksValidationMsg(GettextMsgPayload.Builder builder, String keyset) {
        this(builder.build(), keyset);
    }

    DspBlocksValidationMsg(GettextMsgPayload payload, String keyset) {
        this.payload = payload;
        this.keyset = keyset;
    }

    @Nonnull
    @Override
    public GettextMsgPayload getPayload() {
        return payload;
    }

    @Nonnull
    @Override
    public String getKeysetName() {
        return keyset;
    }
}
