package ru.yandex.partner.core.entity.block.service.validation.defects.presentation;

import javax.annotation.Nonnull;

import ru.yandex.partner.libs.i18n.GettextMsg;
import ru.yandex.partner.libs.i18n.GettextMsgPayload;

import static ru.yandex.partner.libs.i18n.GettextMsgPayload.Builder.msg;

public enum DspValidationMsg implements GettextMsg {
    HAS_DUPLICATES(msg("DSP's with ID %s duplicate"), "lib__Application__Model__Product__RTB.pm"),
    HAS_NOT_FOUND(msg("DSP's with ID %s not found"), "lib__Application__Model__Product__RTB.pm"),
    EMPTY_DSPS_FOR_VIDEO_AD(msg("Choose DSP for Video ad"), "lib__Application__Model__Product__RTB.pm"),
    HAS_NOT_AVAILABLED(msg("Following DSPs are not available: %s"),
            "lib__Application__Model__Role__Block__Has__UnmoderatedDSPs.pm"),
    HAS_NOT_UNMODERATED(msg("Following DSPs are not unmoderated: %s"),
            "lib__Application__Model__Role__Block__Has__UnmoderatedDSPs.pm"),
    PAGE_HAS_NOT_FLAG_UNMODERATED(msg("Page has not flag unmoderated"),
            "lib__Application__Model__Role__Block__Has__UnmoderatedDSPs.pm"),
    EMPTY_BLACK_WHITE_LIST(msg("Empty dsp list with whitelist/blacklist dsp_mode"),
            "lib__Application__Model__Role__Has__DSPS.pm");

    private final GettextMsgPayload payload;
    private final String keyset;

    DspValidationMsg(GettextMsgPayload.Builder builder, String keyset) {
        this(builder.build(), keyset);
    }

    DspValidationMsg(GettextMsgPayload payload, String keyset) {
        this.payload = payload;
        this.keyset = keyset;
    }

    @Nonnull
    @Override
    public GettextMsgPayload getPayload() {
        return payload;
    }

    @Nonnull
    @Override
    public String getKeysetName() {
        return keyset;
    }
}
