package ru.yandex.partner.core.entity.block.service.validation.defects.presentation;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.partner.libs.i18n.GettextMsg;
import ru.yandex.partner.libs.i18n.GettextMsgPayload;

import static ru.yandex.partner.libs.i18n.GettextMsgPayload.Builder.msg;

@ParametersAreNonnullByDefault
public enum OptsValidationMsg implements GettextMsg {
    NON_EXISTED_TAGS(msg("Nonexistent tags: %s"),
            "lib__Application__Model__Role__Has__Tags.pm"),
    SOME_OPTIONS_ARE_UNAVAILABLE(msg("Some options are unavailable"),
            "lib__Application__Model__Role__Has__CustomBKOptions.pm"),
    SOME_OPTIONS_HAVE_CONFLICT_CHANGES(msg("Some options have conflict changes"),
            "lib__Application__Model__Role__Has__CustomBKOptions.pm");


    private final GettextMsgPayload payload;
    private final String keyset;

    OptsValidationMsg(GettextMsgPayload.Builder builder, String keyset) {
        this(builder.build(), keyset);
    }

    OptsValidationMsg(GettextMsgPayload payload, String keyset) {
        this.payload = payload;
        this.keyset = keyset;
    }

    @Nonnull
    @Override
    public GettextMsgPayload getPayload() {
        return payload;
    }

    @Nonnull
    @Override
    public String getKeysetName() {
        return keyset;
    }

}
