package ru.yandex.partner.core.entity.block.service.validation.defects.presentation;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.partner.libs.i18n.GettextMsg;
import ru.yandex.partner.libs.i18n.GettextMsgPayload;

import static ru.yandex.partner.libs.i18n.GettextMsgPayload.Builder.msg;

@ParametersAreNonnullByDefault
public enum SiteVersionValidationMsg implements GettextMsg {
    INVALID_SITE_VERSION(msg("Invalid site version: %s"),
            "lib__Application__Model__Product__AN__ContextOnSite__RTB.pm"),
    UNAVAILABLE_SITE_VERSION(msg("Unavailable site version: %s"),
            "lib__Application__Model__Product__AN__ContextOnSite__RTB.pm");


    private final GettextMsgPayload payload;
    private final String keyset;

    SiteVersionValidationMsg(GettextMsgPayload.Builder builder, String keyset) {
        this(builder.build(), keyset);
    }

    SiteVersionValidationMsg(GettextMsgPayload payload, String keyset) {
        this.payload = payload;
        this.keyset = keyset;
    }

    @Nonnull
    @Override
    public GettextMsgPayload getPayload() {
        return payload;
    }

    @Nonnull
    @Override
    public String getKeysetName() {
        return keyset;
    }

}
