package ru.yandex.partner.core.entity.block.service.validation.defects.presentation;

import javax.annotation.Nonnull;

import ru.yandex.partner.libs.i18n.GettextMsg;
import ru.yandex.partner.libs.i18n.GettextMsgPayload;

import static ru.yandex.partner.libs.i18n.GettextMsgPayload.Builder.msg;

public enum StrategyValidationMsg implements GettextMsg {
    INCORRECT_MINCPM_VALUE(msg("Field 'cpm' should be a positive number less than %d"),
            "lib__QBit__Validator__Type__cpm.pm"),
    INCORRECT_STRATEGY_VALUE(msg("Incorrect strategy value"), "lib__Application__Model__RTBMixin.pm"),
    MINCPM_VALUE_RANGE(msg("mincpm value must be from '0' to '%d'"),
            "lib__Partner__BlockPreset__Specification__Strategies.pm"),
    ADS_CPM_VALUE_RANGE(msg("%s value must be from '0.001' to '%d'"),
            "lib__Partner__BlockPreset__Specification__Strategies.pm"),
    SHOULD_SET_CPM_OR_BLOCK_ADS(msg("You should set CPM or block ads"),
            "lib__Application__Model__Role__Has__Strategies.pm"),
    CANNOT_BLOCKED_ALL_ADS(msg("You cannot blocked all ads"), "lib__Application__Model__Role__Has__Strategies.pm");

    private final GettextMsgPayload payload;
    private final String keyset;

    StrategyValidationMsg(GettextMsgPayload.Builder builder, String keyset) {
        this(builder.build(), keyset);
    }

    StrategyValidationMsg(GettextMsgPayload payload, String keyset) {
        this.payload = payload;
        this.keyset = keyset;
    }

    @Nonnull
    @Override
    public GettextMsgPayload getPayload() {
        return payload;
    }

    @Nonnull
    @Override
    public String getKeysetName() {
        return keyset;
    }
}
