package ru.yandex.partner.core.entity.block.service.validation.type;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.multitype.typesupport.TypeSupportAffectionHelper;
import ru.yandex.partner.core.entity.block.container.BlockContainer;
import ru.yandex.partner.core.entity.block.container.BlockContainerImpl;
import ru.yandex.partner.core.entity.block.model.BaseBlock;
import ru.yandex.partner.core.entity.block.service.OperationMode;
import ru.yandex.partner.core.multitype.repository.PartnerRepositoryTypeSupport;
import ru.yandex.partner.core.multitype.service.validation.type.ValidationTypeSupportFacade;

@Component
@ParametersAreNonnullByDefault
public class BlockValidationTypeSupportFacade
        extends ValidationTypeSupportFacade<BaseBlock, BlockContainer, BlockContainer> {

    @Autowired
    public BlockValidationTypeSupportFacade(
            List<BlockValidationTypeSupport<? extends BaseBlock>> supports,
            TypeSupportAffectionHelper<BaseBlock> typeSupportAffectionHelper,
            List<PartnerRepositoryTypeSupport<? extends BaseBlock, BlockContainer, BlockContainer>> typeSupports) {
        super(supports, typeSupports, typeSupportAffectionHelper, () -> BlockContainerImpl.create(OperationMode.EDIT));
    }
}
