package ru.yandex.partner.core.entity.block.type.adblock;

import javax.annotation.ParametersAreNonnullByDefault;

import NPartner.Page;
import org.jetbrains.annotations.NotNull;
import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.direct.jooqmapper.JsonReaderWriterBuilders;
import ru.yandex.partner.core.entity.block.container.BlockBkDictContainer;
import ru.yandex.partner.core.entity.block.model.BlockWithAdblock;
import ru.yandex.partner.core.entity.block.repository.BlockBkFiller;
import ru.yandex.partner.core.entity.block.repository.type.AbstractBlockRepositoryTypeSupportWithMapper;
import ru.yandex.partner.core.multitype.repository.EmptyTypeSupportModifyStrategy;
import ru.yandex.partner.core.operation.CoreModelProvider;
import ru.yandex.partner.core.props.CoreModel;
import ru.yandex.partner.core.props.ModelPropertyDefault;
import ru.yandex.partner.dbschema.partner.tables.ContextOnSiteRtb;

import static ru.yandex.partner.core.entity.block.model.prop.BlockWithAdblockAdblockBlockPropHolder.ADBLOCK_BLOCK;

@Component
@ParametersAreNonnullByDefault
public class BlockWithAdblockRepositoryTypeSupport
        extends AbstractBlockRepositoryTypeSupportWithMapper<BlockWithAdblock>
        implements CoreModelProvider<BlockWithAdblock>, BlockBkFiller<BlockWithAdblock> {
    private static final CoreModel<BlockWithAdblock> DEFAULT_VALUES =
            CoreModel.forClass(BlockWithAdblock.class)
                    .property(
                            ModelPropertyDefault.<BlockWithAdblock, Boolean>forProperty(ADBLOCK_BLOCK)
                                    .optional().withDefaultValue(false)
                    )
                    .build();

    private final JooqMapper<BlockWithAdblock> mapper;

    @Autowired
    protected BlockWithAdblockRepositoryTypeSupport(DSLContext dslContext) {
        super(dslContext, new EmptyTypeSupportModifyStrategy<>());
        this.mapper = createCommonBlockMapper();
    }

    private static JooqMapper<BlockWithAdblock> createCommonBlockMapper() {
        return JooqMapperBuilder.<BlockWithAdblock>builder()
                .map(
                        JsonReaderWriterBuilders.jsonBoolean(
                                ADBLOCK_BLOCK,
                                ContextOnSiteRtb.CONTEXT_ON_SITE_RTB.OPTS,
                                "adblock_block"
                        )
                )
                .build();
    }

    @Override
    public JooqMapper<BlockWithAdblock> getJooqMapper() {
        return mapper;
    }

    @Override
    public Class<BlockWithAdblock> getTypeClass() {
        return BlockWithAdblock.class;
    }

    @Override
    public CoreModel<BlockWithAdblock> getCoreModel() {
        return DEFAULT_VALUES;
    }

    @Override
    public void fillBkData(@NotNull BlockWithAdblock model, @NotNull Page.TPartnerPage.TBlock.Builder bkData,
                           @NotNull BlockBkDictContainer container) {
        if (Boolean.TRUE.equals(model.getAdblockBlock())) {
            bkData.setAdBlockBlock(model.getAdblockBlock());
        }
    }
}
