package ru.yandex.partner.core.entity.block.type.adfox;

import java.util.Collection;

import javax.annotation.ParametersAreNonnullByDefault;

import NPartner.Page;
import org.jetbrains.annotations.NotNull;
import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.direct.jooqmapperhelper.UpdateHelperAggregator;
import ru.yandex.direct.model.AppliedChanges;
import ru.yandex.partner.core.entity.block.container.BlockBkDictContainer;
import ru.yandex.partner.core.entity.block.model.BlockWithAdfox;
import ru.yandex.partner.core.entity.block.repository.BlockBkFiller;
import ru.yandex.partner.core.entity.block.repository.type.AbstractBlockRepositoryTypeSupportWithMapper;
import ru.yandex.partner.core.operation.CoreModelProvider;
import ru.yandex.partner.core.props.CoreModel;
import ru.yandex.partner.core.props.ModelPropertyDefault;
import ru.yandex.partner.core.utils.CommonConverters;

import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.convertibleProperty;
import static ru.yandex.partner.core.entity.block.model.prop.BlockWithAdfoxAdfoxBlockPropHolder.ADFOX_BLOCK;
import static ru.yandex.partner.dbschema.partner.Tables.CONTEXT_ON_SITE_RTB;

@Component
@ParametersAreNonnullByDefault
public class BlockWithAdfoxRepositoryTypeSupport
        extends AbstractBlockRepositoryTypeSupportWithMapper<BlockWithAdfox>
        implements CoreModelProvider<BlockWithAdfox>, BlockBkFiller<BlockWithAdfox> {
    private static final CoreModel<BlockWithAdfox> DEFAULT_VALUES =
            CoreModel.forClass(BlockWithAdfox.class)
                    .property(
                            ModelPropertyDefault.<BlockWithAdfox, Boolean>forProperty(ADFOX_BLOCK)
                                    .optional().withDefaultValue(false)
                    )
                    .build();

    private final JooqMapper<BlockWithAdfox> mapper;

    @Autowired
    protected BlockWithAdfoxRepositoryTypeSupport(DSLContext dslContext) {
        super(dslContext);
        this.mapper = createCommonBlockMapper();
    }

    private static JooqMapper<BlockWithAdfox> createCommonBlockMapper() {
        return JooqMapperBuilder.<BlockWithAdfox>builder()
                .map(convertibleProperty(ADFOX_BLOCK, CONTEXT_ON_SITE_RTB.ADFOX_BLOCK,
                        CommonConverters::booleanFromLong, CommonConverters::booleanToLong))
                .build();
    }

    @Override
    public JooqMapper<BlockWithAdfox> getJooqMapper() {
        return mapper;
    }

    @Override
    public Class<BlockWithAdfox> getTypeClass() {
        return BlockWithAdfox.class;
    }

    @Override
    public void processUpdate(UpdateHelperAggregator updateHelperAggregator,
                              Collection<AppliedChanges<BlockWithAdfox>> appliedChanges) {
//        updateHelperAggregator.getOrCreate(CONTEXT_ON_SITE_RTB.UNIQUE_ID)
//                .processUpdateAll(mapper, appliedChanges);
    }

    @Override
    public void enrichModelFromOtherTables(DSLContext dslContext, Collection<BlockWithAdfox> blocks) {
    }

    @Override
    public CoreModel<BlockWithAdfox> getCoreModel() {
        return DEFAULT_VALUES;
    }

    @Override
    public void fillBkData(@NotNull BlockWithAdfox model, @NotNull Page.TPartnerPage.TBlock.Builder bkData,
                           @NotNull BlockBkDictContainer container) {
        if (model.getAdfoxBlock() != null) {
            bkData.setAdFoxBlock(model.getAdfoxBlock());
        }
    }
}
