package ru.yandex.partner.core.entity.block.type.adfox;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.partner.core.entity.block.container.BlockContainer;
import ru.yandex.partner.core.entity.block.model.BlockWithAdfox;
import ru.yandex.partner.core.entity.block.service.validation.type.AbstractBlockValidationTypeSupport;

@Component
public class BlockWithAdfoxValidationTypeSupport extends AbstractBlockValidationTypeSupport<BlockWithAdfox> {

    private final Validator<BlockWithAdfox, Defect> validator;

    @Autowired
    public BlockWithAdfoxValidationTypeSupport(BlockWithAdfoxValidatorProvider validatorProvider) {
        this.validator = validatorProvider.validator();
    }

    @Override
    public Class<BlockWithAdfox> getTypeClass() {
        return BlockWithAdfox.class;
    }

    @Override
    public ValidationResult<List<BlockWithAdfox>, Defect> validate(
            BlockContainer container,
            ValidationResult<List<BlockWithAdfox>, Defect> vr) {

        return new ListValidationBuilder<>(vr)
                .checkEachBy(validator)
                .getResult();
    }
}
