package ru.yandex.partner.core.entity.block.type.adfox;

import org.springframework.stereotype.Component;

import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;
import ru.yandex.partner.core.entity.block.model.BlockWithAdfox;

import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;

@Component
public class BlockWithAdfoxValidatorProvider {

    public <M extends BlockWithAdfox> Validator<M, Defect> validator() {
        return block -> {
            ModelItemValidationBuilder<M> vb = ModelItemValidationBuilder.of(block);
            vb.item(BlockWithAdfox.ADFOX_BLOCK)
                    .check(notNull());

            return vb.getResult();
        };
    }
}
