package ru.yandex.partner.core.entity.block.type.adfoxnotifier;

import java.util.List;

import org.springframework.stereotype.Component;

import ru.yandex.direct.model.AppliedChanges;
import ru.yandex.partner.core.block.BlockType;
import ru.yandex.partner.core.entity.block.container.BlockContainer;
import ru.yandex.partner.core.entity.block.model.BaseBlock;
import ru.yandex.partner.core.entity.block.model.BlockWithAdfoxNotifier;
import ru.yandex.partner.core.entity.block.model.BlockWithCommonFields;
import ru.yandex.partner.core.entity.block.service.type.update.AbstractBlockUpdateOperationTypeSupport;
import ru.yandex.partner.core.multitype.repository.PartnerRepositoryTypeSupportFacade;
import ru.yandex.partner.core.service.adfox.AdfoxService;

@Component
public class BlockWithAdfoxNotifierUpdateOperationTypeSupport extends
        AbstractBlockUpdateOperationTypeSupport<BlockWithAdfoxNotifier> {

    private final AdfoxService adfoxService;

    public BlockWithAdfoxNotifierUpdateOperationTypeSupport(
            PartnerRepositoryTypeSupportFacade<BaseBlock, BlockType, BlockContainer, BlockContainer> repositoryFacade,
            AdfoxService adfoxService
    ) {
        super(repositoryFacade);
        this.adfoxService = adfoxService;
    }

    @Override
    public Class<BlockWithAdfoxNotifier> getTypeClass() {
        return BlockWithAdfoxNotifier.class;
    }

    @Override
    public void afterExecution(
            BlockContainer updateContainer,
            List<AppliedChanges<BlockWithAdfoxNotifier>> appliedChanges
    ) {
        super.afterExecution(updateContainer, appliedChanges);

        appliedChanges.stream()
                .filter(c -> c.changed(BlockWithCommonFields.CAPTION))
                .map(AppliedChanges::getModel)
                .filter(m -> m.getPlaceId() != null)
                .forEach(m -> adfoxService.updateBlockName(m.getPlaceId(), m.getCaption()));
    }
}
