package ru.yandex.partner.core.entity.block.type.altcode

import NPartner.Page
import org.springframework.stereotype.Component
import ru.yandex.partner.core.entity.block.container.BlockBkDictContainer
import ru.yandex.partner.core.entity.block.model.BlockWithAlternativeCodeAndAltSize
import ru.yandex.partner.core.entity.block.repository.BlockBkFiller

@Component
class BlockWithAlternativeCodeAndAltSizeBkFiller: BlockBkFiller<BlockWithAlternativeCodeAndAltSize> {
    override fun fillBkData(
        block: BlockWithAlternativeCodeAndAltSize,
        bkData: Page.TPartnerPage.TBlock.Builder,
        container: BlockBkDictContainer
    ) {
        if (block.alternativeCode != null) {
            bkData.altWidth = block.altWidth?.toInt()?:0
            bkData.altHeight = block.altHeight?.toInt()?:0
        }
    }

    override fun getTypeClass(): Class<BlockWithAlternativeCodeAndAltSize> {
        return BlockWithAlternativeCodeAndAltSize::class.java
    }
}
