package ru.yandex.partner.core.entity.block.type.altcode;

import javax.annotation.ParametersAreNonnullByDefault;

import NPartner.Page.TPartnerPage;
import org.jetbrains.annotations.NotNull;
import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.partner.core.entity.block.container.BlockBkDictContainer;
import ru.yandex.partner.core.entity.block.model.BlockWithAlternativeCode;
import ru.yandex.partner.core.entity.block.repository.BlockBkFiller;
import ru.yandex.partner.core.entity.block.repository.type.AbstractBlockRepositoryTypeSupportWithMapper;
import ru.yandex.partner.core.operation.CoreModelProvider;
import ru.yandex.partner.core.props.CoreModel;
import ru.yandex.partner.core.props.ModelPropertyDefault;

import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;
import static ru.yandex.partner.dbschema.partner.Tables.CONTEXT_ON_SITE_RTB;

@Component
@ParametersAreNonnullByDefault
public class BlockWithAlternativeCodeRepositoryTypeSupport
        extends AbstractBlockRepositoryTypeSupportWithMapper<BlockWithAlternativeCode>
        implements CoreModelProvider<BlockWithAlternativeCode>, BlockBkFiller<BlockWithAlternativeCode> {
    private static final CoreModel<BlockWithAlternativeCode> DEFAULT_VALUES =
            CoreModel.forClass(BlockWithAlternativeCode.class)
                    .property(
                            ModelPropertyDefault.<BlockWithAlternativeCode, String>forProperty(
                                            BlockWithAlternativeCode.ALTERNATIVE_CODE
                                    )
                                    .optional().withDefaultValue("")
                    )
                    .build();

    private final JooqMapper<BlockWithAlternativeCode> mapper;

    @Autowired
    protected BlockWithAlternativeCodeRepositoryTypeSupport(DSLContext dslContext) {
        super(dslContext);
        this.mapper = createCommonBlockMapper();
    }

    private static JooqMapper<BlockWithAlternativeCode> createCommonBlockMapper() {
        return JooqMapperBuilder.<BlockWithAlternativeCode>builder()
                .map(property(BlockWithAlternativeCode.ALTERNATIVE_CODE, CONTEXT_ON_SITE_RTB.ALTERNATIVE_CODE))
                .build();
    }

    @Override
    public JooqMapper<BlockWithAlternativeCode> getJooqMapper() {
        return mapper;
    }

    @Override
    public Class<BlockWithAlternativeCode> getTypeClass() {
        return BlockWithAlternativeCode.class;
    }

    @Override
    public CoreModel<BlockWithAlternativeCode> getCoreModel() {
        return DEFAULT_VALUES;
    }

    @Override
    public void fillBkData(@NotNull BlockWithAlternativeCode block,
                           @NotNull TPartnerPage.TBlock.Builder bkData,
                           @NotNull BlockBkDictContainer container) {
        if (block.getAlternativeCode() != null) {
            bkData.setAlternativeCode(block.getAlternativeCode());
        }
    }
}
