package ru.yandex.partner.core.entity.block.type.altcode;

import java.util.Set;

import org.springframework.stereotype.Component;

import ru.yandex.direct.model.ModelProperty;
import ru.yandex.partner.core.block.BlockType;
import ru.yandex.partner.core.entity.block.container.BlockContainer;
import ru.yandex.partner.core.entity.block.model.BaseBlock;
import ru.yandex.partner.core.entity.block.model.BlockWithAlternativeCode;
import ru.yandex.partner.core.entity.block.service.type.update.AbstractBlockUpdateOperationTypeSupport;
import ru.yandex.partner.core.multitype.repository.PartnerRepositoryTypeSupportFacade;

@Component
public class BlockWithAlternativeCodeUpdateOperationTypeSupport
        extends AbstractBlockUpdateOperationTypeSupport<BlockWithAlternativeCode> {
    private static final Set<ModelProperty<? super BlockWithAlternativeCode, ?>> NEED_UPDATE_IN_BK_FIELDS = Set.of(
            BlockWithAlternativeCode.ALTERNATIVE_CODE
    );

    public BlockWithAlternativeCodeUpdateOperationTypeSupport(PartnerRepositoryTypeSupportFacade<BaseBlock, BlockType,
            BlockContainer, BlockContainer> repositoryFacade) {
        super(repositoryFacade);
    }

    @Override
    public Class<BlockWithAlternativeCode> getTypeClass() {
        return BlockWithAlternativeCode.class;
    }

    @Override
    public Set<ModelProperty<? super BlockWithAlternativeCode, ?>> needBsResyncProps() {
        return NEED_UPDATE_IN_BK_FIELDS;
    }
}
