package ru.yandex.partner.core.entity.block.type.altcode;

import java.util.List;

import org.springframework.stereotype.Component;

import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.partner.core.entity.block.container.BlockContainer;
import ru.yandex.partner.core.entity.block.model.BlockWithAlternativeCode;
import ru.yandex.partner.core.entity.block.service.validation.type.AbstractBlockValidationTypeSupport;

@Component
public class BlockWithAlternativeCodeValidationTypeSupport
        extends AbstractBlockValidationTypeSupport<BlockWithAlternativeCode> {

    private final Validator<BlockWithAlternativeCode, Defect> validator;

    public BlockWithAlternativeCodeValidationTypeSupport(BlockWithAlternativeCodeValidatorProvider validatorProvider) {
        this.validator = validatorProvider.validator();
    }

    @Override
    public Class<BlockWithAlternativeCode> getTypeClass() {
        return BlockWithAlternativeCode.class;
    }

    @Override
    public ValidationResult<List<BlockWithAlternativeCode>, Defect> validate(
            BlockContainer container,
            ValidationResult<List<BlockWithAlternativeCode>, Defect> vr) {

        return new ListValidationBuilder<>(vr)
                .checkEachBy(validator)
                .getResult();
    }
}
