package ru.yandex.partner.core.entity.block.type.altcode;

import org.springframework.stereotype.Component;

import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;
import ru.yandex.partner.core.entity.block.model.BlockWithAlternativeCode;

import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;

@Component
public class BlockWithAlternativeCodeValidatorProvider {

    public <M extends BlockWithAlternativeCode> Validator<M, Defect> validator() {
        return block -> {
            ModelItemValidationBuilder<M> vb = ModelItemValidationBuilder.of(block);
            vb.item(BlockWithAlternativeCode.ALTERNATIVE_CODE)
                    .check(notNull());
            return vb.getResult();
        };
    }
}
