package ru.yandex.partner.core.entity.block.type.altsize;

import java.util.Collection;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.partner.core.entity.block.model.BlockWithAltSize;
import ru.yandex.partner.core.entity.block.repository.type.AbstractBlockRepositoryTypeSupportWithMapper;

import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;
import static ru.yandex.partner.dbschema.partner.Tables.CONTEXT_ON_SITE_RTB;

@Component
@ParametersAreNonnullByDefault
public class BlockWithAltSizeRepositoryTypeSupport
        extends AbstractBlockRepositoryTypeSupportWithMapper<BlockWithAltSize> {
    private final JooqMapper<BlockWithAltSize> mapper;

    @Autowired
    protected BlockWithAltSizeRepositoryTypeSupport(DSLContext dslContext) {
        super(dslContext);
        this.mapper = createCommonBlockMapper();
    }

    @Override
    public JooqMapper<BlockWithAltSize> getJooqMapper() {
        return mapper;
    }

    private static JooqMapper<BlockWithAltSize> createCommonBlockMapper() {
        return JooqMapperBuilder.<BlockWithAltSize>builder()
                .map(property(BlockWithAltSize.ALT_WIDTH, CONTEXT_ON_SITE_RTB.ALT_WIDTH))
                .map(property(BlockWithAltSize.ALT_HEIGHT, CONTEXT_ON_SITE_RTB.ALT_HEIGHT))
                .build();
    }

    @Override
    public Class<BlockWithAltSize> getTypeClass() {
        return BlockWithAltSize.class;
    }

    @Override
    public void enrichModelFromOtherTables(DSLContext dslContext, Collection<BlockWithAltSize> blocks) {
    }
}
