package ru.yandex.partner.core.entity.block.type.altsize;

import java.util.Set;

import org.springframework.stereotype.Component;

import ru.yandex.direct.model.ModelProperty;
import ru.yandex.partner.core.block.BlockType;
import ru.yandex.partner.core.entity.block.container.BlockContainer;
import ru.yandex.partner.core.entity.block.model.BaseBlock;
import ru.yandex.partner.core.entity.block.model.BlockWithAltSize;
import ru.yandex.partner.core.entity.block.service.type.update.AbstractBlockUpdateOperationTypeSupport;
import ru.yandex.partner.core.multitype.repository.PartnerRepositoryTypeSupportFacade;

@Component
public class BlockWithAltSizeUpdateOperationTypeSupport
        extends AbstractBlockUpdateOperationTypeSupport<BlockWithAltSize> {
    private static final Set<ModelProperty<? super BlockWithAltSize, ?>> NEED_UPDATE_IN_BK_FIELDS = Set.of(
            BlockWithAltSize.ALT_WIDTH,
            BlockWithAltSize.ALT_HEIGHT
    );

    public BlockWithAltSizeUpdateOperationTypeSupport(PartnerRepositoryTypeSupportFacade<BaseBlock, BlockType,
            BlockContainer, BlockContainer> repositoryFacade) {
        super(repositoryFacade);
    }

    @Override
    public Set<ModelProperty<? super BlockWithAltSize, ?>> needBsResyncProps() {
        return NEED_UPDATE_IN_BK_FIELDS;
    }

    @Override
    public Class<BlockWithAltSize> getTypeClass() {
        return BlockWithAltSize.class;
    }
}
