package ru.yandex.partner.core.entity.block.type.altsize

import org.springframework.stereotype.Component
import ru.yandex.direct.validation.builder.ListValidationBuilder
import ru.yandex.direct.validation.builder.Validator
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult
import ru.yandex.partner.core.entity.block.container.BlockContainer
import ru.yandex.partner.core.entity.block.model.BlockWithAltSize
import ru.yandex.partner.core.entity.block.service.validation.type.AbstractBlockValidationTypeSupport

@Component
class BlockWithAltSizeValidationTypeSupport(
    _validatorProvider: BlockWithAltSizeValidatorProvider) : AbstractBlockValidationTypeSupport<BlockWithAltSize>() {
    private val validator: Validator<BlockWithAltSize, Defect<Any>> = _validatorProvider.validator();


    override fun getTypeClass(): Class<BlockWithAltSize> {
        return BlockWithAltSize::class.java;
    }

    override fun validate(container: BlockContainer?, vr: ValidationResult<MutableList<BlockWithAltSize>,
        Defect<Any>>): ValidationResult<MutableList<BlockWithAltSize>, Defect<Any>> {
        return ListValidationBuilder(vr)
            .checkEachBy(validator)
            .result
    }

}
