package ru.yandex.partner.core.entity.block.type.altsize

import org.springframework.stereotype.Component
import ru.yandex.direct.validation.builder.Validator
import ru.yandex.direct.validation.builder.When
import ru.yandex.direct.validation.constraint.CommonConstraints
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder
import ru.yandex.partner.core.entity.block.model.BlockWithAltSize
import ru.yandex.partner.core.entity.block.service.validation.defects.BlockDefects
import ru.yandex.partner.core.validation.constraints.PartnerNumberConstraints

@Component
class BlockWithAltSizeValidatorProvider {
    fun <M : BlockWithAltSize> validator(): Validator<M, Defect<Any>> {
        return Validator { block: M ->
            val vb = ModelItemValidationBuilder.of(block)
            if (block.altWidth != null) {
                vb.item(BlockWithAltSize.ALT_WIDTH)
                    .check(PartnerNumberConstraints.isIntegerNumberGreaterThanOrEqual(1L))
                if (!vb.result.hasAnyErrors()) {
                    vb.item(BlockWithAltSize.ALT_HEIGHT)
                        .check(CommonConstraints.notNull(), BlockDefects.emptyAltHeight(), When.isValid())
                }
            }
            if (block.altHeight != null) {
                vb.item(BlockWithAltSize.ALT_HEIGHT)
                    .check(PartnerNumberConstraints.isIntegerNumberGreaterThanOrEqual(1L), When.isValid())
                if (!vb.result.hasAnyErrors()) {
                    vb.item(BlockWithAltSize.ALT_WIDTH)
                        .check(CommonConstraints.notNull(), BlockDefects.emptyAltWidht(), When.isValid())
                }
            }
            vb.result
        }
    }
}
