package ru.yandex.partner.core.entity.block.type.base;

import java.util.List;
import java.util.Map;

import one.util.streamex.StreamEx;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.partner.core.block.BlockUniqueIdConverter;
import ru.yandex.partner.core.entity.block.container.BlockContainer;
import ru.yandex.partner.core.entity.block.model.BaseBlock;
import ru.yandex.partner.core.entity.block.service.type.add.AbstractBlockAddOperationTypeSupport;
import ru.yandex.partner.core.entity.blockseq.BlockSequenceService;


public abstract class BaseBlockAddOperationTypeSupport<B extends BaseBlock>
        extends AbstractBlockAddOperationTypeSupport<B> {
    private final BlockSequenceService blockSequenceService;

    @Autowired
    public BaseBlockAddOperationTypeSupport(BlockSequenceService blockSequenceService) {
        this.blockSequenceService = blockSequenceService;
    }

    @Override
    public void onPreValidated(BlockContainer addContainer, List<B> models) {
        var pageIdBlocks = StreamEx.of(models).groupingBy(BaseBlock::getPageId);
        var newBlockIds = blockSequenceService.getNextBlockIds(StreamEx.of(pageIdBlocks.entrySet())
                .toMap(Map.Entry::getKey, it -> (long) it.getValue().size()), false);
        pageIdBlocks.forEach((pageId, blocks) -> {
            var nextIds = newBlockIds.get(pageId);

            for (int i = 0; i < blocks.size(); i++) {
                var curBlock = blocks.get(i);
                var blockId = nextIds.get(i);
                curBlock.setBlockId(blockId);
                var newId = BlockUniqueIdConverter.convertToUniqueId(
                        blockSequenceService.getUniqueIdPrefix(),
                        curBlock.getPageId(),
                        blockId);
                curBlock.setId(newId);
            }
        });
    }

    @Override
    public void onDuplicate(BlockContainer addModelContainer, List<B> models) {
        models.forEach(model -> {
            model.setId(null);
            model.setBlockId(null);
        });
    }
}
