package ru.yandex.partner.core.entity.block.type.base;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.partner.core.entity.block.container.BlockContainer;
import ru.yandex.partner.core.entity.block.model.BaseBlock;
import ru.yandex.partner.core.entity.block.service.validation.type.AbstractBlockValidationTypeSupport;
import ru.yandex.partner.core.entity.common.validation.NullPropertiesValidatorProvider;

@Component
public class BaseBlockValidationTypeSupport extends AbstractBlockValidationTypeSupport<BaseBlock> {
    private final Validator<BaseBlock, Defect> validator;
    private final NullPropertiesValidatorProvider<BaseBlock> nullPropertiesValidatorProvider;

    @Autowired
    public BaseBlockValidationTypeSupport(BaseBlockValidatorProvider validatorProvider,
                                          NullPropertiesValidatorProvider<BaseBlock> nullPropertiesValidatorProvider) {
        this.validator = validatorProvider.validator();
        this.nullPropertiesValidatorProvider = nullPropertiesValidatorProvider;
    }

    @Override
    public Class<BaseBlock> getTypeClass() {
        return BaseBlock.class;
    }

    @Override
    public ValidationResult<List<BaseBlock>, Defect> addPreValidate(BlockContainer container,
                                                                    ValidationResult<List<BaseBlock>, Defect> vr) {
        return new ListValidationBuilder<>(vr)
                .checkEachBy(nullPropertiesValidatorProvider.addPreValidator(List.of(BaseBlock.BLOCK_ID, BaseBlock.ID)),
                        When.isTrue(container.getMode().creation()))
                .getResult();
    }

    @Override
    public ValidationResult<List<BaseBlock>, Defect> validate(
            BlockContainer container,
            ValidationResult<List<BaseBlock>, Defect> vr) {

        return new ListValidationBuilder<>(vr)
                .checkEachBy(validator)
                .getResult();
    }
}
