package ru.yandex.partner.core.entity.block.type.base;

import org.springframework.stereotype.Component;

import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;
import ru.yandex.partner.core.block.BlockUniqueIdConverter;
import ru.yandex.partner.core.entity.block.model.BaseBlock;

import static ru.yandex.direct.validation.constraint.CommonConstraints.isEqual;
import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;
import static ru.yandex.partner.core.entity.block.service.validation.defects.BlockDefects.invalidUniqueId;
import static ru.yandex.partner.core.entity.block.service.validation.defects.BlockDefects.unknownBlockType;

@Component
public class BaseBlockValidatorProvider {

    public <M extends BaseBlock> Validator<M, Defect> validator() {
        return block -> {
            ModelItemValidationBuilder<M> vb = ModelItemValidationBuilder.of(block);

            Long prefixId = BlockUniqueIdConverter.Prefixes.numberByClass(block.getClass());
            if (prefixId != null) {
                if (block.getPageId() != null && block.getBlockId() != null) {
                    long expectedUniqueId =
                            BlockUniqueIdConverter.convertToUniqueId(prefixId, block.getPageId(), block.getBlockId());

                    vb.item(BaseBlock.ID)
                            .check(notNull())
                            .check(isEqual(expectedUniqueId, invalidUniqueId()));
                } else {
                    vb.item(BaseBlock.PAGE_ID).check(notNull());
                    vb.item(BaseBlock.BLOCK_ID).check(notNull());
                }
            } else {
                vb.check(baseBlock -> unknownBlockType());
            }

            return vb.getResult();
        };
    }
}
